/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.UserGroup;

@Node
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GroupMember
extends Entity {
    @Relationship(type="IS_MEMBER_OF", direction=Relationship.Direction.OUTGOING)
    @NonNull
    private UserGroup group;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Relationship(type="MEMBER_CLIENT", direction=Relationship.Direction.OUTGOING)
    @NonNull
    private Client client;
    private String pendingInvite;
    private String pendingRequest;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Relationship(type="SPONSOR_CLIENT", direction=Relationship.Direction.OUTGOING)
    private Client sponsor;
    private Instant lastUpdate = Instant.now();
    private Instant lastRead;

    public boolean joined() {
        return this.pendingInvite == null && this.pendingRequest == null;
    }

    public GroupMember invite(Client sponsor) {
        this.setPendingInvite(UUID.randomUUID().toString());
        this.setLastUpdate(Instant.now());
        this.setSponsor(sponsor);
        return this;
    }

    public GroupMember request() {
        this.setPendingRequest(UUID.randomUUID().toString());
        this.setLastUpdate(Instant.now());
        return this;
    }

    private GroupMember accepted() {
        this.setPendingInvite(null);
        this.setPendingRequest(null);
        this.setLastUpdate(Instant.now());
        return this;
    }

    public GroupMember accept() {
        return this.accepted();
    }

    public GroupMember allow(Client sponsor) {
        this.setSponsor(sponsor);
        return this.accepted();
    }

    @NonNull
    @Generated
    public UserGroup getGroup() {
        return this.group;
    }

    @NonNull
    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getPendingInvite() {
        return this.pendingInvite;
    }

    @Generated
    public String getPendingRequest() {
        return this.pendingRequest;
    }

    @Generated
    public Client getSponsor() {
        return this.sponsor;
    }

    @Generated
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Generated
    public Instant getLastRead() {
        return this.lastRead;
    }

    @Generated
    public void setGroup(@NonNull UserGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated
    public void setClient(@NonNull Client client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }

    @Generated
    public void setPendingInvite(String pendingInvite) {
        this.pendingInvite = pendingInvite;
    }

    @Generated
    public void setPendingRequest(String pendingRequest) {
        this.pendingRequest = pendingRequest;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated
    public void setSponsor(Client sponsor) {
        this.sponsor = sponsor;
    }

    @Generated
    public void setLastUpdate(Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Generated
    public void setLastRead(Instant lastRead) {
        this.lastRead = lastRead;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupMember)) {
            return false;
        }
        GroupMember other = (GroupMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupMember;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GroupMember(super=" + super.toString() + ")";
    }

    @Generated
    public GroupMember() {
    }

    @Generated
    public GroupMember(@NonNull UserGroup group, @NonNull Client client) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.group = group;
        this.client = client;
    }
}

