/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import java.security.Provider;
import java.security.Security;
import lombok.Generated;
import nl.martijndwars.webpush.PushService;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"webpush.privateKey"})
@Configuration
public class WebPushConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebPushConfig.class);
    @Value(value="${webpush.privateKey}")
    private String privateKey;
    @Value(value="${webpush.publicKey}")
    private String publicKey;
    @Value(value="${webpush.subject}")
    private String subject;

    @Bean
    PushService pushService() {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            PushService pushService = new PushService();
            pushService.setPublicKey(this.publicKey);
            pushService.setPrivateKey(this.privateKey);
            pushService.setSubject(this.subject);
            return pushService;
        }
        catch (Exception e) {
            log.error("Can't configure push service", (Throwable)e);
            return null;
        }
    }
}

