/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.vrspace.server.core.ClassUtil;

public class FileUtil {
    public static File downloadDir() {
        File dir = new File(System.getProperty("user.home") + "/Downloads");
        if (!dir.isDirectory() || !dir.canWrite()) {
            dir = new File(System.getProperty("java.io.tmpdir"));
        }
        return dir;
    }

    public static String contentDir() {
        return ClassUtil.projectHomeDirectory() + "/content";
    }

    public static String uploadDir() {
        return ClassUtil.projectHomeDirectory() + "/content/tmp";
    }

    public static String generatedContentDir() {
        return ClassUtil.projectHomeDirectory() + "/content/generated";
    }

    public static Path unzip(File file, File dir) throws IOException {
        Path targetDir = dir.toPath().toAbsolutePath();
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(file));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(entry.getName()).normalize();
                if (!resolvedPath.startsWith(targetDir)) {
                    throw new RuntimeException("Entry with an illegal path: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
        return targetDir;
    }
}

