/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.ID;
import org.vrspace.server.types.Owned;

@Node
@Owned
public class Game
extends VRObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Game.class);
    private String name;
    private int numberOfPlayers = 0;
    private String status;
    @Transient
    private transient Set<ID> players = ConcurrentHashMap.newKeySet();

    public void join(Client client) {
        client.addListener(this);
        this.players.add(client.getObjectId());
        this.event("joined", client);
    }

    public void quit(Client client) {
        this.players.remove(client.getObjectId());
        client.removeListener(this);
        this.event("quit", client);
    }

    public void start(Client client) {
        this.event("start", client);
    }

    public void end(Client client) {
        this.event("end", client);
    }

    private void event(String type, Client client) {
        this.numberOfPlayers = this.players.size();
        VREvent event = new VREvent(this);
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put(type, client.getObjectId());
        event.setChanges(changes);
        this.notifyListeners(event);
        log.debug("Client " + client + " " + type + " " + this);
    }

    @Override
    public void processEvent(VREvent event) {
        if (!event.getSource().isActive() && event.getSource() instanceof Client) {
            this.quit((Client)event.getSource());
        }
    }

    @Generated
    public Game() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getNumberOfPlayers() {
        return this.numberOfPlayers;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Set<ID> getPlayers() {
        return this.players;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNumberOfPlayers(int numberOfPlayers) {
        this.numberOfPlayers = numberOfPlayers;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setPlayers(Set<ID> players) {
        this.players = players;
    }

    @Override
    @Generated
    public String toString() {
        return "Game(name=" + this.getName() + ", numberOfPlayers=" + this.getNumberOfPlayers() + ", status=" + this.getStatus() + ", players=" + this.getPlayers() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Game)) {
            return false;
        }
        Game other = (Game)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Game;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

