/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.obj.Client;

public class ClientControllerBase
extends ApiBase {
    @Autowired
    WorldManager worldManager;
    @Autowired
    ClientFactory clientFactory;

    protected Client findClient(HttpSession session) {
        return this.findClient(session, null);
    }

    protected Client findClient(HttpSession session, VRObjectRepository db) {
        String clientId = (String)session.getAttribute("local-user-id");
        Client client = this.worldManager.getClient(clientId);
        if (client == null) {
            if (db == null) {
                throw new SecurityException("The client is not connected");
            }
            client = db.getClient(clientId);
        }
        return client;
    }

    protected boolean isAuthenticated(HttpSession session) {
        return ClientControllerBase.isAuthenticated(session, this.clientFactory);
    }

    protected Client getAuthorisedClient(HttpSession session) {
        return this.getAuthorisedClient(session, null);
    }

    protected Client getAuthorisedClient(HttpSession session, VRObjectRepository db) {
        if (!this.isAuthenticated(session)) {
            throw new SecurityException("Anonymous user");
        }
        Client client = this.findClient(session, db);
        if (client != null && client.isTemporary()) {
            throw new SecurityException("Temporary user");
        }
        return client;
    }
}

