/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.FileUtil;
import org.vrspace.server.core.GroupManager;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Content;
import org.vrspace.server.obj.GroupMember;
import org.vrspace.server.obj.GroupMessage;
import org.vrspace.server.obj.UserGroup;

@RestController
@RequestMapping(value={"/vrspace/api/groups"})
public class Groups
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Groups.class);
    public static final String PATH = "/vrspace/api/groups";
    @Autowired
    GroupManager groupManager;

    @GetMapping
    @ResponseBody
    public List<UserGroup> listMyGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group list, user: " + client);
        return this.groupManager.listGroups(client);
    }

    @GetMapping(value={"/owned"})
    @ResponseBody
    public List<UserGroup> listOwnedGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group list, owner: " + client);
        return this.groupManager.listOwnedGroups(client);
    }

    @PostMapping(produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserGroup create(String name, Optional<Boolean> isPublic, Optional<Boolean> isTemporary, Optional<Boolean> isDirect, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group create, user: " + client + " group: " + name + " public: " + isPublic + " temporary: " + isTemporary);
        return this.groupManager.createGroup(client, new UserGroup(name, isPublic.isPresent() && isPublic.get() != false, isTemporary.isPresent() && isTemporary.get() != false, isDirect.isPresent() && isDirect.get() != false));
    }

    @PutMapping(produces={"application/json"})
    public void update(@RequestBody UserGroup group, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group update, user: " + client + " group: " + group);
        this.groupManager.updateGroup(client, group);
    }

    @DeleteMapping(value={"/{groupId}"})
    public void deleteGroup(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group delete, user: " + client + " group: " + group);
        this.groupManager.deleteGroup(client, group);
    }

    @GetMapping(value={"/{groupId}"})
    public UserGroup getGroup(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(groupId);
        log.debug("Group get, user: " + client + " group: " + group);
        return group;
    }

    @GetMapping(value={"/{groupId}/show"})
    public List<Client> show(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group show, user: " + client + " group: " + group);
        return this.groupManager.show(group);
    }

    @PostMapping(value={"/{groupId}/join"})
    public void join(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(groupId);
        log.debug("Group join, user: " + client + " group: " + group);
        this.groupManager.join(group, client);
    }

    @PostMapping(value={"/{groupId}/invite"})
    public void invite(@PathVariable String groupId, String clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group invite, user: " + client + " group: " + group + " invited: " + clientId);
        this.groupManager.invite(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/ask"})
    public void ask(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(groupId);
        log.debug("Group ask, user: " + client + " group: " + group);
        this.groupManager.ask(group, client);
    }

    @PostMapping(value={"/{groupId}/accept"})
    public void accept(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group accept, user: " + client + " group: " + group);
        this.groupManager.accept(group, client);
    }

    @PostMapping(value={"/{groupId}/allow"})
    public void allow(@PathVariable String groupId, String clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group allow, user: " + client + " group: " + group);
        this.groupManager.allow(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/leave"})
    public void leave(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group leave, user: " + client + " group: " + group);
        this.groupManager.leave(group, client);
    }

    @PostMapping(value={"/{groupId}/kick"})
    public void kick(@PathVariable String groupId, String clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group kick, user: " + client + " group: " + group);
        this.groupManager.kick(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/write"})
    public String write(@PathVariable String groupId, @RequestBody String text, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group write, user: " + client + " group: " + group + " text: " + text);
        return this.groupManager.write(client, group, text);
    }

    @PostMapping(value={"/{groupId}/share"})
    public void shareWorld(@PathVariable String groupId, @RequestBody GroupMessage worldShare, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group share world, user: " + client + " group: " + group + " worldShare: " + worldShare);
        this.groupManager.worldInvite(client, group, worldShare.getContent(), worldShare.getLink());
    }

    @GetMapping(value={"/{groupId}/requests"})
    public List<GroupMember> listRequests(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Group requests, user: " + client + " group: " + group);
        return this.groupManager.pendingRequests(group, client);
    }

    @GetMapping(value={"/invitations"})
    public List<GroupMember> listInvites(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group invites, user: " + client);
        return this.groupManager.pendingInvitations(client);
    }

    @GetMapping(value={"/unread"})
    public List<UserGroup> listUnreadGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Unread groups, user: " + client);
        return this.groupManager.unreadGroups(client);
    }

    @GetMapping(value={"/{groupId}/unread"})
    public List<GroupMessage> listUnreadMessages(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Unread messages, user: " + client + " group: " + group);
        List<GroupMessage> ret = this.groupManager.unreadMessages(client, group);
        return ret;
    }

    @GetMapping(value={"/{groupId}/owners"})
    public List<Client> listOwners(@PathVariable String groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        log.debug("Unread messages, user: " + client + " group: " + group);
        return this.groupManager.listOwners(group);
    }

    @PutMapping(value={"/{groupId}/{messageId}/attachment"})
    public void attach(HttpSession session, String fileName, String contentType, @PathVariable String groupId, @PathVariable String messageId, @RequestPart MultipartFile fileData) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        String path = FileUtil.attachmentDir();
        Long fileSize = fileData.getSize();
        File dest = new File(path + File.separator + fileName);
        dest.mkdirs();
        log.debug("uploading attachment " + groupId + "/" + messageId + contentType + "/" + fileData.getContentType() + " to " + dest + " size " + fileSize);
        try (InputStream inputStream = fileData.getInputStream();){
            Files.copy(inputStream, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            log.error("Upload error", (Throwable)e);
        }
        Content content = new Content();
        content.setFileName(fileName);
        content.setFolder(path);
        content.setContentType(contentType);
        content.setLength(fileSize);
        this.groupManager.attach(client, group, messageId, content);
    }

    @DeleteMapping(value={"/{groupId}/{messageId}/attachment"})
    public void detach(HttpSession session, String fileName, @PathVariable String groupId, @PathVariable String messageId) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        this.groupManager.detach(client, group, messageId, fileName);
    }

    @GetMapping(value={"/{groupId}/{messageId}/attachment/{fileName}"})
    public StreamingResponseBody getAttachment(HttpSession session, HttpServletResponse response, @PathVariable String groupId, @PathVariable String messageId, @PathVariable String fileName) {
        FileInputStream inputStream;
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroupById(client, groupId);
        Content content = this.groupManager.getAttachment(client, group, messageId, fileName);
        response.setContentType(content.getContentType());
        response.setHeader("Content-Disposition", "attachment;filename=\"" + content.getFileName() + "\"");
        File file = new File(content.getFolder(), content.getFileName());
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File not found " + file, e);
        }
        return outputStream -> {
            int bytesRead;
            byte[] buffer = new byte[0x400000];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        };
    }
}

