/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.sketchfab.AuthResponse;
import org.vrspace.server.api.sketchfab.DownloadResponse;
import org.vrspace.server.api.sketchfab.FileInfo;
import org.vrspace.server.api.sketchfab.ModelSearchRequest;
import org.vrspace.server.api.sketchfab.ModelSearchResponse;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.core.FileUtil;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.ContentCategory;
import org.vrspace.server.obj.GltfModel;

@RestController
@RequestMapping(value={"/vrspace/api/sketchfab"})
public class Sketchfab
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Sketchfab.class);
    public static final String PATH = "/vrspace/api/sketchfab";
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    VRObjectRepository db;
    private final String loginUrl = "https://sketchfab.com/oauth2/token/";
    private final String searchUrl = "https://api.sketchfab.com/v3/search";
    @Value(value="${sketchfab.clientId:none}")
    private String clientId;
    @Value(value="${sketchfab.clientSecret:none}")
    private String clientSecret;
    @Value(value="${sketchfab.redirectUri:none}")
    private String redirectUri;
    private String token;
    private String referrer;

    @GetMapping(value={"/available"})
    public boolean isAvailable() {
        return !"none".equals(this.clientId) && !"none".equals(this.clientSecret) && !"none".equals(this.redirectUri);
    }

    @GetMapping(value={"/login"})
    public LoginResponse sketchfabLogin(HttpServletRequest request) {
        this.referrer = request.getHeader("Referer");
        LoginResponse ret = new LoginResponse("https://sketchfab.com/oauth2/authorize/?response_type=code&client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri);
        return ret;
    }

    @GetMapping(value={"/oauth2"})
    public ResponseEntity<String> sketchfabCallback(String code) {
        log.info("Login code " + code);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"code", (Object)code);
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)this.redirectUri);
        HttpEntity<MultiValueMap<String, String>> request = this.authRequest((MultiValueMap<String, String>)map);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", request, AuthResponse.class, new Object[0]);
        log.debug("Login response: " + response);
        AuthResponse auth = (AuthResponse)response.getBody();
        if (auth.getExpires_in() < 604800) {
            auth = this.refresh(auth.getRefresh_token());
        }
        this.token = auth.getAccess_token();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{this.referrer})).body((Object)("Redirecting to " + this.referrer));
    }

    private HttpEntity<MultiValueMap<String, String>> authRequest(MultiValueMap<String, String> fields) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity(fields, (MultiValueMap)headers);
        return request;
    }

    private AuthResponse refresh(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"refresh_token", (Object)refreshToken);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", this.authRequest((MultiValueMap<String, String>)map), AuthResponse.class, new Object[0]);
        log.debug("Refresh response: " + response);
        return (AuthResponse)response.getBody();
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<ModelSearchResponse> searchModels(@RequestBody ModelSearchRequest params) {
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
        try {
            HttpRequest request = HttpRequest.newBuilder(params.toURI("https://api.sketchfab.com/v3/search")).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            ModelSearchResponse ret = (ModelSearchResponse)this.objectMapper.readValue(body, ModelSearchResponse.class);
            return ResponseEntity.ofNullable((Object)ret);
        }
        catch (JacksonException e) {
            log.error("Internal error", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            log.error("Connection error", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_GATEWAY);
        }
        catch (InterruptedException e) {
            log.error("Connection timeout", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT);
        }
        catch (Exception e) {
            log.error("Internal error", (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<GltfModel> download(String uid, HttpServletRequest request) {
        GltfModel model;
        if (this.token == null) {
            this.referrer = request.getHeader("Referer");
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Optional<GltfModel> existing = this.db.findGltfModelByUid(uid);
        if (existing.isPresent()) {
            model = existing.get();
            log.warn("Model already already exists: " + existing.get().getId());
            File modelFile = new File(ClassUtil.projectHomeDirectory() + "/content/" + model.mainCategory() + "/" + model.getFileName());
            if (modelFile.exists()) {
                log.warn("Model directory also exists, exiting: " + modelFile);
                return new ResponseEntity((Object)model, (HttpStatusCode)HttpStatus.OK);
            }
            log.warn("Model directory does not exist, downloading again");
        }
        String url = "https://api.sketchfab.com/v3/models/" + uid + "/download";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, DownloadResponse.class, new Object[0]);
        log.debug("Download response: " + response);
        FileInfo gltf = ((DownloadResponse)response.getBody()).getGltf();
        try {
            model = this.modelInfo(uid);
            if (existing.isPresent()) {
                model.setId(existing.get().getId());
                log.warn("Overriding existing model data " + model.getId());
            }
            String category = model.mainCategory();
            URL fileUrl = new URL(gltf.getUrl());
            String fileName = fileUrl.getPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            String modelName = fileName.substring(0, fileName.lastIndexOf("."));
            modelName = modelName.replaceAll("\\.", "");
            File modelDir = new File(FileUtil.contentDir() + "/" + category + "/" + modelName);
            if (modelDir.exists()) {
                log.warn("Destination directory already exists, download skipped: " + modelDir);
            } else {
                log.info("Downloading " + gltf.getUrl() + " size " + gltf.getSize());
                File file = new File(FileUtil.downloadDir(), fileName);
                IOUtils.copy((URL)fileUrl, (File)file);
                log.info("Downloaded to " + file.getCanonicalPath());
                Path dest = FileUtil.unzip(file, modelDir);
                log.info("Unzipped to " + dest);
            }
            model.setFileName(modelDir.getName());
            model.setMesh("/content/" + model.mainCategory() + "/" + model.getFileName() + "/scene.gltf");
            this.db.save(model);
            log.info("Stored " + model);
            return new ResponseEntity((Object)model, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException("Error downloading " + gltf.getUrl(), e);
        }
    }

    private GltfModel modelInfo(String uid) throws JsonMappingException, JsonProcessingException {
        GltfModel ret = new GltfModel();
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://api.sketchfab.com/v3/models/" + uid;
        String json = (String)restTemplate.getForEntity(url, String.class, new Object[0]).getBody();
        log.debug("Model info: " + json);
        Map info = (Map)this.objectMapper.readValue(json, Map.class);
        ret.setUid((String)info.get("uid"));
        ret.setUri((String)info.get("uri"));
        ret.setName((String)info.get("name"));
        ret.setDescription((String)info.get("description"));
        ret.setLicense((String)((Map)info.get("license")).get("slug"));
        ret.setAuthor((String)((Map)info.get("user")).get("displayName"));
        List categories = (List)info.get("categories");
        for (Map category : categories) {
            log.debug("Category: " + category.get("slug") + " " + category.get("name"));
            String catName = (String)category.get("slug");
            Optional<ContentCategory> oCat = this.db.findContentCategoryByName(catName);
            if (oCat.isPresent()) {
                ret.getCategories().add(oCat.get());
                continue;
            }
            ContentCategory cat = new ContentCategory(catName);
            cat = (ContentCategory)this.db.save(cat);
            ret.getCategories().add(cat);
        }
        return ret;
    }

    public static class LoginResponse {
        String url;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginResponse)) {
                return false;
            }
            LoginResponse other = (LoginResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Sketchfab.LoginResponse(url=" + this.getUrl() + ")";
        }

        @Generated
        public LoginResponse() {
        }

        @Generated
        public LoginResponse(String url) {
            this.url = url;
        }
    }
}

