/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.ID;

@RestController
@RequestMapping(value={"/vrspace/api/world"})
public class WorldObjects
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorldObjects.class);
    public static final String PATH = "/vrspace/api/world";
    private static String CLASS = "VRObject";
    @Autowired
    private WorldManager worldManager;
    @Autowired
    private VRObjectRepository db;

    @PutMapping(value={"/add"})
    public VRObject addObject(HttpSession session, @RequestBody VRObject obj) {
        Client client = this.findClient(session, this.db);
        VRObject ret = this.worldManager.add(client, obj);
        client.getScene().publish(ret);
        return ret;
    }

    @DeleteMapping(value={"/remove"})
    public void removeObject(HttpSession session, String id) {
        Client client = this.findClient(session, this.db);
        VRObject obj = client.getScene().get(new ID(CLASS, id));
        if (obj != null) {
            this.worldManager.remove(client, obj);
            client.getScene().unpublish(obj);
        }
    }

    @PatchMapping(value={"/coordinates"})
    public void objectCoordinates(HttpSession session, @RequestBody VRObject changes) {
        Client client = this.findClient(session, this.db);
        VRObject obj = client.getScene().get(new ID(CLASS, changes.getId()));
        if (obj == null) {
            throw new IllegalArgumentException("Object not in the scene");
        }
        ClientRequest req = new ClientRequest(obj);
        req.setClient(client);
        if (changes.getPosition() != null) {
            req.addChange("position", changes.getPosition());
        }
        if (changes.getRotation() != null) {
            req.addChange("rotation", changes.getRotation());
        }
        if (changes.getScale() != null) {
            req.addChange("scale", changes.getScale());
        }
        try {
            this.worldManager.dispatch(req);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Internal error", (Throwable)e);
        }
    }
}

