/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;
import org.vrspace.server.core.VRSpaceDB;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.GroupMember;
import org.vrspace.server.obj.GroupMessage;
import org.vrspace.server.obj.UserGroup;

@DependsOn(value={"database"})
public interface GroupRepository
extends Neo4jRepository<Entity, String>,
VRSpaceDB {
    @Query(value="MATCH (ug:UserGroup)<-[owned:IS_OWNED]-(o:Ownership)-[owns:IS_OWNER]->(c:Client) WHERE c.id = $clientId RETURN o,owns,c,owned,ug ORDER BY ug.name")
    public List<UserGroup> listOwnedGroups(String var1);

    @Query(value="MATCH (ug:UserGroup)<-[owned:IS_OWNED]-(o:Ownership)-[owns:IS_OWNER]->(c:Client) WHERE ug.id = $groupId RETURN o,owns,c,owned,ug")
    public List<Client> listGroupOwners(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE c.id=$clientId AND gm.pendingInvite IS NULL AND gm.pendingRequest IS NULL RETURN ug ORDER BY ug.name")
    public List<UserGroup> listUserGroups(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE c.id=$clientId AND gm.pendingInvite IS NULL AND gm.pendingRequest IS NULL RETURN gm, r, ug ORDER BY ug.name")
    public List<GroupMember> listGroupMemberships(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE ug.id=$groupId AND gm.pendingRequest IS NULL AND gm.pendingInvite IS NULL RETURN c")
    public List<Client> listGroupClients(String var1);

    @Query(value="MATCH (gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE ug.id=$groupId AND gm.pendingRequest IS NULL AND gm.pendingInvite IS NULL RETURN gm, r, ug")
    public List<GroupMember> listGroupMembers(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE ug.id=$groupId AND c.id=$clientId RETURN gm, c, mc, r, ug")
    public Optional<GroupMember> findGroupMember(String var1, String var2);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE c.id=$clientId AND ug.name=$groupName RETURN ug")
    public Optional<UserGroup> findGroupByName(String var1, String var2);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE c.id=$clientId AND ug.id=$groupId RETURN ug")
    public Optional<UserGroup> findGroupById(String var1, String var2);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE AND ug.name=$groupName RETURN ug")
    public Optional<UserGroup> findGroupByName(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup) WHERE ug.id=$groupId AND gm.pendingRequest IS NOT NULL RETURN gm, c, mc, r, ug")
    public List<GroupMember> listPendingRequests(String var1);

    @Query(value="MATCH (c:Client)<-[mc:MEMBER_CLIENT]-(gm:GroupMember)-[r:IS_MEMBER_OF]->(ug:UserGroup), (s:Client)<-[sc:SPONSOR_CLIENT]-(gm:GroupMember) WHERE c.id=$clientId AND gm.pendingInvite IS NOT NULL RETURN gm, c, mc, r, ug, sc, s ORDER BY ug.name")
    public List<GroupMember> listPendingInvitations(String var1);

    @Query(value="MATCH (msg:GroupMessage)-[r:PARENT_GROUP]->(ug:UserGroup) WHERE ug.id=$groupId AND ($since IS NULL OR msg.timestamp >= $since) return count(msg)")
    public Integer unreadMessageCount(String var1, Instant var2);

    @Query(value="MATCH (msg:GroupMessage)-[p:PARENT_GROUP]->(ug:UserGroup) WHERE ug.id=$groupId AND ($since IS NULL OR msg.timestamp >= $since) return msg ORDER BY msg.timestamp")
    public List<GroupMessage> messagesSince(String var1, Instant var2);
}

