/*
 * Decompiled with CFR 0.152.
 */
package org.w007.activemq;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w007.activemq.DestinationReapingBroker;

public class DestinationReaperPlugin
implements BrokerPlugin {
    public static final Logger log = LoggerFactory.getLogger(DestinationReaperPlugin.class);
    private volatile long destinationTimeToLive = TimeUnit.DAYS.toMillis(1L);
    private volatile String destination;

    public DestinationReaperPlugin() {
    }

    DestinationReaperPlugin(String destination, long destinationTimeToLive) {
        this.destination = destination;
        this.destinationTimeToLive = destinationTimeToLive;
    }

    public Broker installPlugin(Broker broker) throws Exception {
        log.info("Installing Destination Reaper broker plugin for destination {} and timeout {} ms", (Object)this.destination, (Object)this.destinationTimeToLive);
        return new DestinationReapingBroker(broker, this.destination, this.destinationTimeToLive);
    }

    public long getDestinationTimeToLive() {
        return this.destinationTimeToLive;
    }

    public void setDestinationTimeToLive(long destinationTimeToLive) {
        this.destinationTimeToLive = destinationTimeToLive;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }
}

