/*
 * Decompiled with CFR 0.152.
 */
package org.w007.activemq;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w007.activemq.ExecutionOrder;

public class DestinationReapingBroker
extends BrokerFilter {
    private final long destinationTimeToLive;
    private final ScheduledExecutorService scheduler = this.createScheduler();
    private ScheduledFuture<?> task;
    private final DestinationReaperTask reaperTask;
    private final DestinationFilter queueFilter;
    private final DestinationFilter topicFilter;
    private final LinkedHashSet<ExecutionOrder> executionOrders;
    private final Logger log = LoggerFactory.getLogger(DestinationReapingBroker.class);

    public DestinationReapingBroker(Broker next, String pattern, long destinationTimeToLive) {
        super(next);
        this.destinationTimeToLive = destinationTimeToLive;
        this.reaperTask = new DestinationReaperTask();
        this.queueFilter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue(pattern));
        this.topicFilter = DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQTopic(pattern));
        this.executionOrders = new LinkedHashSet();
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        Destination created = super.addDestination(context, destination, createIfTemporary);
        if (this.shouldBeReaped(destination)) {
            this.addExecutionOrder(destination);
        }
        return created;
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        super.addDestinationInfo(context, info);
        ActiveMQDestination destination = info.getDestination();
        if (this.shouldBeReaped(destination)) {
            this.addExecutionOrder(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExecutionOrder(ActiveMQDestination destination) {
        long timeToDieMillis = System.currentTimeMillis() + this.destinationTimeToLive;
        this.log.debug("Adding execution order for {} at time {}", (Object)destination, (Object)timeToDieMillis);
        LinkedHashSet<ExecutionOrder> linkedHashSet = this.executionOrders;
        synchronized (linkedHashSet) {
            this.executionOrders.add(new ExecutionOrder(destination, timeToDieMillis));
        }
    }

    boolean shouldBeReaped(ActiveMQDestination destination) {
        return this.queueFilter.matches(destination) || this.topicFilter.matches(destination);
    }

    Set<ExecutionOrder> getExecutionOrders() {
        return this.executionOrders;
    }

    public void start() throws Exception {
        super.start();
        this.scheduleReaping();
    }

    public void stop() throws Exception {
        this.stopReaping();
        super.stop();
    }

    private void scheduleReaping() {
        long rate = this.destinationTimeToLive / 5L;
        this.task = this.scheduler.scheduleAtFixedRate(this.reaperTask, rate, rate, TimeUnit.MILLISECONDS);
    }

    private void stopReaping() {
        if (this.task != null) {
            this.task.cancel(false);
        }
    }

    private ScheduledExecutorService createScheduler() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    private class DestinationReaperTask
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(DestinationReaperTask.class);

        private DestinationReaperTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.log.debug("Reaping destinations");
                long currentTimeMillis = System.currentTimeMillis();
                BrokerService brokerService = DestinationReapingBroker.this.getBrokerService();
                LinkedHashSet linkedHashSet = DestinationReapingBroker.this.executionOrders;
                synchronized (linkedHashSet) {
                    for (ExecutionOrder executionOrder : DestinationReapingBroker.this.executionOrders) {
                        if (executionOrder.timeToDieMillis <= currentTimeMillis) {
                            DestinationReapingBroker.this.executionOrders.remove(executionOrder);
                            this.removeDestination(brokerService, executionOrder.destination);
                            continue;
                        }
                        this.log.debug("Order {} is in the future as of {}; delta: {}", new Object[]{executionOrder, currentTimeMillis, executionOrder.timeToDieMillis - currentTimeMillis});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Error while finding destinations to reap: {}", (Object)e.getMessage());
                this.log.debug("Stack trace", (Throwable)e);
            }
        }

        private void removeDestination(BrokerService brokerService, ActiveMQDestination destination) {
            try {
                this.log.info("Removing destination {}", (Object)destination);
                brokerService.removeDestination(destination);
            }
            catch (Exception e) {
                this.log.error("Could not remove destination {}: .", (Object)destination, (Object)e.getMessage());
                this.log.debug("Stack trace", (Throwable)e);
            }
        }
    }
}

