/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.File;
import java.io.Serializable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.flatspec.AsyncFlatSpec;
import org.wabase.AppFileStreamer$;
import org.wabase.FileBufferedFlow$;
import org.wabase.StreamsEnv$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u0001!!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!9A\tAI\u0001\n\u0003)\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u0007%\u0002\u0001\u000b\u0011B\u001b\t\u000fM\u0003!\u0019!C\u0001)\"1Q\u000b\u0001Q\u0001\n%BqA\u0016\u0001C\u0002\u0013\u0005q\u000b\u0003\u0004Y\u0001\u0001\u0006Ia\b\u0002\u0019\r&dWMQ;gM\u0016\u0014X\r\u001a#bi\u00064En\\<UKN$(B\u0001\u0007\u000e\u0003\u00199\u0018MY1tK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cF\u0007\u0002')\u0011A#F\u0001\tM2\fGo\u001d9fG*\u0011a#D\u0001\ng\u000e\fG.\u0019;fgRL!\u0001G\n\u0003\u001b\u0005\u001b\u0018P\\2GY\u0006$8\u000b]3d\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t1\"\u0001\tuKN$()\u001e4gKJ,GM\u00127poR)qdM\u001e>\u0005B!\u0001eJ\u00150\u001b\u0005\t#B\u0001\u0012$\u0003!\u00198-\u00197bINd'B\u0001\u0013&\u0003\u0019\u0019HO]3b[*\ta%\u0001\u0003bW.\f\u0017B\u0001\u0015\"\u0005\u0019\u0019v.\u001e:dKB\u0011!&L\u0007\u0002W)\u0011A&J\u0001\u0005kRLG.\u0003\u0002/W\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0005A\nT\"A\u0013\n\u0005I*#a\u0002(piV\u001bX\r\u001a\u0005\u0006i\t\u0001\r!N\u0001\u0002]B\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t\u0019\u0011J\u001c;\t\u000bq\u0012\u0001\u0019A\u001b\u0002\u0015\t,hMZ3s'&TX\rC\u0003?\u0005\u0001\u0007q(A\u0006nCb4\u0015\u000e\\3TSj,\u0007C\u0001\u001cA\u0013\t\tuG\u0001\u0003M_:<\u0007bB\"\u0003!\u0003\u0005\r!N\u0001\u000b_V$()\u001e4TSj,\u0017A\u0007;fgR\u0014UO\u001a4fe\u0016$g\t\\8xI\u0011,g-Y;mi\u0012\"T#\u0001$+\u0005U:5&\u0001%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!C;oG\",7m[3e\u0015\tiu'\u0001\u0006b]:|G/\u0019;j_:L!a\u0014&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003tSj,W#A\u001b\u0002\u000bML'0\u001a\u0011\u0002\u000fA\fG\u000f^3s]V\t\u0011&\u0001\u0005qCR$XM\u001d8!\u0003\u0019\u0019x.\u001e:dKV\tq$A\u0004t_V\u00148-\u001a\u0011")
public class FileBufferedDataFlowTest
extends AsyncFlatSpec {
    private final int size;
    private final ByteString pattern = ByteString$.MODULE$.apply((byte[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.size()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)FileBufferedDataFlowTest.$anonfun$pattern$1(BoxesRunTime.unboxToInt((Object)x$1))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte()));
    private final Source<ByteString, NotUsed> source = this.testBufferedFlow(this.size(), 10, 100L, 10);

    public Source<ByteString, NotUsed> testBufferedFlow(int n, int bufferSize, long maxFileSize, int outBufSize) {
        Graph buffer = FileBufferedFlow$.MODULE$.create(bufferSize, maxFileSize, outBufSize);
        return ((Source)Source$.MODULE$.fromIterator((Function0 & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), n).iterator()).map((Function1 & Serializable & scala.Serializable)b -> ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)BoxesRunTime.unboxToInt((Object)b)})))).async().via(buffer);
    }

    public int testBufferedFlow$default$4() {
        return 8192;
    }

    public int size() {
        return this.size;
    }

    public ByteString pattern() {
        return this.pattern;
    }

    public Source<ByteString, NotUsed> source() {
        return this.source;
    }

    public static final /* synthetic */ byte $anonfun$pattern$1(int x$1) {
        return (byte)x$1;
    }

    public FileBufferedDataFlowTest() {
        this.size = 100;
        this.it().should("buffer bytes flow with fixed downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> ((Source)this.source().map((Function1 & Serializable & scala.Serializable)x -> {
            Thread.sleep(10L);
            return x;
        })).runReduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23));
        this.it().should("buffer bytes flow with no downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> this.source().runReduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.$plus$plus(x$5), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.it().should("buffer bytes flow with variable downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> ((Source)this.source().map((Function1 & Serializable & scala.Serializable)x -> {
            Thread.sleep(Random$.MODULE$.nextInt(101));
            return x;
        })).runReduce((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.$plus$plus(x$7), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.it().should("buffer bytes from file with variable downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> {
            int fileSize = 1000000;
            int bufferSize = 4096;
            int maxFileSize = 0x100000;
            int outBufSize = 4096;
            Source source = (Source)Source$.MODULE$.fromIterator((Function0 & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), fileSize).iterator()).map((Function1 & Serializable & scala.Serializable)b -> ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)BoxesRunTime.unboxToInt((Object)b)})));
            Graph buffer = FileBufferedFlow$.MODULE$.create(bufferSize, (long)maxFileSize, outBufSize);
            File file = File.createTempFile("buffer_test_file", ".data");
            return ((Future)source.runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), StreamsEnv$.MODULE$.mat())).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Future)((Source)FileIO$.MODULE$.fromPath(file.toPath(), FileIO$.MODULE$.fromPath$default$2()).async().via(buffer).map((Function1 & Serializable & scala.Serializable)b -> {
                Thread.sleep(Random$.MODULE$.nextInt(11));
                return b;
            })).runWith((Graph)AppFileStreamer$.MODULE$.sha256sink(this.executionContext()), StreamsEnv$.MODULE$.mat()), this.executionContext()).zip((Future)source.runWith((Graph)AppFileStreamer$.MODULE$.sha256sink(this.executionContext()), StreamsEnv$.MODULE$.mat())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String hash1 = (String)tuple2._1();
                String hash2 = (String)tuple2._2();
                String $org_scalatest_assert_macro_left = hash1;
                String $org_scalatest_assert_macro_right = hash2;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                return assertion;
            }, this.executionContext()).andThen((PartialFunction)new scala.Serializable(null, file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final <A1 extends Try<Assertion>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.file$1.delete());
                    return (B1)bl;
                }

                public final boolean isDefinedAt(Try<Assertion> x1) {
                    Try<Assertion> try_ = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    this.file$1 = file$1;
                }
            }, this.executionContext());
        }, new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }
}

