/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.Tag;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.wabase.BorerDatetimeEncoders$;
import org.wabase.Format$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class BorerDatetimeDecoders$ {
    public static BorerDatetimeDecoders$ MODULE$;
    private final Decoder<Timestamp> javaSqlTimestampDecoder;
    private final Decoder<Date> javaSqlDateDecoder;
    private final Regex hh_mm_regex;
    private final Decoder<Time> javaSqlTimeDecoder;
    private final Decoder<LocalDate> localDateDecoder;
    private final Decoder<LocalTime> localTimeDecoder;
    private final Decoder<LocalDateTime> localDateTimeDecoder;

    static {
        new BorerDatetimeDecoders$();
    }

    public Decoder<Timestamp> javaSqlTimestampDecoder() {
        return this.javaSqlTimestampDecoder;
    }

    public Decoder<Date> javaSqlDateDecoder() {
        return this.javaSqlDateDecoder;
    }

    private Regex hh_mm_regex() {
        return this.hh_mm_regex;
    }

    public Time toSqlTime(String timeString) {
        if (this.hh_mm_regex().pattern().matcher(timeString).matches()) {
            return Time.valueOf(new StringBuilder(3).append(timeString).append(":00").toString());
        }
        return Time.valueOf(timeString);
    }

    public Decoder<Time> javaSqlTimeDecoder() {
        return this.javaSqlTimeDecoder;
    }

    public Decoder<LocalDate> localDateDecoder() {
        return this.localDateDecoder;
    }

    public Decoder<LocalTime> localTimeDecoder() {
        return this.localTimeDecoder;
    }

    public Decoder<LocalDateTime> localDateTimeDecoder() {
        return this.localDateTimeDecoder;
    }

    private BorerDatetimeDecoders$() {
        MODULE$ = this;
        this.javaSqlTimestampDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            switch (n) {
                case 1024: 
                case 2048: {
                    return Timestamp.valueOf(reader.readString());
                }
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return new Timestamp(Format$.MODULE$.jsIsoDateTime().parse(reader.readString()).getTime());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Timestamp((long)(reader.readDouble() * (double)1000));
            }
            throw reader.unexpectedDataItem("Timestamp");
        });
        this.javaSqlDateDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            switch (n) {
                case 1024: 
                case 2048: {
                    return Date.valueOf(reader.readString());
                }
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return new Date(Format$.MODULE$.jsIsoDateTime().parse(reader.readString()).getTime());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Date(reader.readLong() * 1000L);
            }
            throw reader.unexpectedDataItem("Date");
        });
        this.hh_mm_regex = new StringOps(Predef$.MODULE$.augmentString("^\\d\\d?:\\d\\d?$")).r();
        this.javaSqlTimeDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            switch (n) {
                case 1024: 
                case 2048: {
                    return MODULE$.toSqlTime(reader.readString());
                }
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return new Time(Format$.MODULE$.jsIsoDateTime().parse(reader.readString()).getTime());
            }
            if (reader.tryReadTag((Tag)BorerDatetimeEncoders$.MODULE$.TimeTag())) {
                return new Time((long)(reader.readDouble() * (double)1000));
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Time((long)(reader.readDouble() * (double)1000));
            }
            throw reader.unexpectedDataItem("Time");
        });
        this.localDateDecoder = Decoder$.MODULE$.apply(r -> ((Date)r.apply(MODULE$.javaSqlDateDecoder())).toLocalDate());
        this.localTimeDecoder = Decoder$.MODULE$.apply(r -> ((Time)r.apply(MODULE$.javaSqlTimeDecoder())).toLocalTime());
        this.localDateTimeDecoder = Decoder$.MODULE$.apply(r -> ((Timestamp)r.apply(MODULE$.javaSqlTimestampDecoder())).toLocalDateTime());
    }
}

