/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import javax.sql.DataSource;
import org.tresql.Resources;
import org.wabase.AppMetadata;
import org.wabase.Loggable;
import org.wabase.package;
import org.wabase.package$;
import org.wabase.package$ConnectionPools$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class DbAccess$
implements Loggable {
    public static DbAccess$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DbAccess$();
    }

    private Logger logger$lzycompute() {
        DbAccess$ dbAccess$ = this;
        synchronized (dbAccess$) {
            if (!this.bitmap$0) {
                this.logger = Loggable.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void commitAndCloseConnection(Connection dbConn) {
        try {
            if (!dbConn.isClosed()) {
                dbConn.commit();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(31).append("Failed to commit db connection ").append(dbConn).toString(), ex);
                }
            }
            throw throwable;
        }
        this.closeConnection(dbConn);
    }

    public void rollbackAndCloseConnection(Connection dbConn) {
        try {
            if (!dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(34).append("Failed to rollback db transaction ").append(dbConn).toString(), ex);
                }
            }
            throw throwable;
        }
        this.closeConnection(dbConn);
    }

    public void closeConnection(Connection dbConn) {
        try {
            if (!dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(30).append("Failed to close db connection ").append(dbConn).toString(), ex);
                }
            }
            throw throwable;
        }
    }

    public void closeConns(Function1<Connection, BoxedUnit> connCloser, Resources resources) {
        Connection connection = resources.conn();
        ((TraversableOnce)resources.extraResources().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Resources>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Resources r;
                A1 A1 = x1;
                if (A1 != null && (r = (Resources)A1._2()).conn() != null) {
                    return (B1)r.conn();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Resources> x1) {
                Resources r;
                Tuple2<String, Resources> tuple2 = x1;
                return tuple2 != null && (r = (Resources)tuple2._2()).conn() != null;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList().$colon$colon((Object)connection).foreach(connCloser);
    }

    public Resources initResources(Resources initialResources, package.PoolName poolName, Seq<AppMetadata.DbAccessKey> extraDb) {
        Function0 & Serializable & scala.Serializable dsFactory = (Function0 & Serializable & scala.Serializable)() -> package$ConnectionPools$.MODULE$.apply(poolName);
        Map dsExtraFactories = ((TraversableOnce)extraDb.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AppMetadata.DbAccessKey dbAccessKey = x0$1;
            if (dbAccessKey != null) {
                String db = dbAccessKey.db();
                String cp = dbAccessKey.cp();
                return new Tuple2((Object)db, (Function0 & Serializable & scala.Serializable)() -> package$ConnectionPools$.MODULE$.apply(cp == null ? db : cp));
            }
            throw new MatchError((Object)dbAccessKey);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return this.initConns(initialResources, (Function0<DataSource>)dsFactory, (Map<String, Function0<DataSource>>)dsExtraFactories);
    }

    public Resources initConns(Resources initialResources, Function0<DataSource> dsFactory, Map<String, Function0<DataSource>> dsExtraFactories) {
        Resources resources;
        Connection dbConn2 = ((DataSource)dsFactory.apply()).getConnection();
        ObjectRef extraConns = ObjectRef.create((Object)Nil$.MODULE$);
        try {
            Resources initRes = initialResources.withConn(dbConn2);
            resources = dsExtraFactories.isEmpty() ? initRes : (Resources)dsExtraFactories.foldLeft((Object)initRes, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Resources res = (Resources)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String db = (String)tuple22._1();
                        Function0 fac = (Function0)tuple22._2();
                        if (res.extraResources().contains((Object)db)) {
                            Connection extraConn = ((DataSource)fac.apply()).getConnection();
                            extraConns$1.elem = ((List)extraConns$1.elem).$colon$colon((Object)extraConn);
                            return res.withUpdatedExtra(db, (Function1 & Serializable & scala.Serializable)x$12 -> x$12.withConn((Connection)((List)extraConns$1.elem).head()));
                        }
                        return res;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                Connection connection = dbConn2;
                ((List)extraConns.elem).$colon$colon((Object)connection).foreach((Function1 & Serializable & scala.Serializable)dbConn -> {
                    DbAccess$.MODULE$.rollbackAndCloseConnection(dbConn);
                    return BoxedUnit.UNIT;
                });
                throw ex;
            }
            throw throwable;
        }
        return resources;
    }

    public void closeResources(Resources res, Option<Throwable> err) {
        if (err.isEmpty()) {
            this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
                DbAccess$.MODULE$.commitAndCloseConnection(dbConn);
                return BoxedUnit.UNIT;
            }, res);
            return;
        }
        this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
            DbAccess$.MODULE$.rollbackAndCloseConnection(dbConn);
            return BoxedUnit.UNIT;
        }, res);
    }

    public <A> A withConn(Resources template, package.PoolName poolName, Seq<AppMetadata.DbAccessKey> extraDb, Function1<Resources, A> f) {
        Object object;
        Resources res = this.initResources(template, poolName, extraDb);
        try {
            object = f.apply((Object)res);
        }
        finally {
            this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
                DbAccess$.MODULE$.closeConnection(dbConn);
                return BoxedUnit.UNIT;
            }, res);
        }
        return (A)object;
    }

    public <A> package.PoolName withConn$default$2() {
        return package$.MODULE$.DEFAULT_CP();
    }

    public <A> Seq<AppMetadata.DbAccessKey> withConn$default$3() {
        return Nil$.MODULE$;
    }

    public <A> A withRollbackConn(Resources template, package.PoolName poolName, Seq<AppMetadata.DbAccessKey> extraDb, Function1<Resources, A> f) {
        Object object;
        Resources res = this.initResources(template, poolName, extraDb);
        try {
            object = f.apply((Object)res);
        }
        finally {
            this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
                DbAccess$.MODULE$.rollbackAndCloseConnection(dbConn);
                return BoxedUnit.UNIT;
            }, res);
        }
        return (A)object;
    }

    public <A> package.PoolName withRollbackConn$default$2() {
        return package$.MODULE$.DEFAULT_CP();
    }

    public <A> Seq<AppMetadata.DbAccessKey> withRollbackConn$default$3() {
        return Nil$.MODULE$;
    }

    public <A> A transaction(Resources template, package.PoolName poolName, Seq<AppMetadata.DbAccessKey> extraDb, Function1<Resources, A> f) {
        Object object;
        Resources res = this.initResources(template, poolName, extraDb);
        try {
            Object result = f.apply((Object)res);
            this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
                DbAccess$.MODULE$.commitAndCloseConnection(dbConn);
                return BoxedUnit.UNIT;
            }, res);
            object = result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                this.closeConns((Function1<Connection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dbConn -> {
                    DbAccess$.MODULE$.rollbackAndCloseConnection(dbConn);
                    return BoxedUnit.UNIT;
                }, res);
                throw ex;
            }
            throw throwable;
        }
        return (A)object;
    }

    public <A> package.PoolName transaction$default$2() {
        return package$.MODULE$.DEFAULT_CP();
    }

    public <A> Seq<AppMetadata.DbAccessKey> transaction$default$3() {
        return Nil$.MODULE$;
    }

    private DbAccess$() {
        MODULE$ = this;
        Loggable.$init$(this);
    }
}

