/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import akka.stream.Attributes$;
import akka.stream.Graph;
import akka.stream.IOResult;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.flatspec.AsyncFlatSpec;
import org.wabase.AppFileStreamer$;
import org.wabase.FileBufferedFlow$;
import org.wabase.InsufficientStorageException;
import org.wabase.StreamsEnv$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileDoubleRef;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001}3AAC\u0006\u0001!!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!9!\nAI\u0001\n\u0003Y\u0005b\u0002,\u0001\u0005\u0004%\ta\u0016\u0005\u00071\u0002\u0001\u000b\u0011B\u001f\t\u000fe\u0003!\u0019!C\u00015\"11\f\u0001Q\u0001\n%Bq\u0001\u0018\u0001C\u0002\u0013\u0005Q\f\u0003\u0004_\u0001\u0001\u0006Ia\b\u0002\u0019\r&dWMQ;gM\u0016\u0014X\r\u001a#bi\u00064En\\<UKN$(B\u0001\u0007\u000e\u0003\u00199\u0018MY1tK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cF\u0007\u0002')\u0011A#F\u0001\tM2\fGo\u001d9fG*\u0011a#D\u0001\ng\u000e\fG.\u0019;fgRL!\u0001G\n\u0003\u001b\u0005\u001b\u0018P\\2GY\u0006$8\u000b]3d\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t1\"\u0001\tuKN$()\u001e4gKJ,GM\u00127poR)qdO!D\u0011B!\u0001eJ\u00150\u001b\u0005\t#B\u0001\u0012$\u0003!\u00198-\u00197bINd'B\u0001\u0013&\u0003\u0019\u0019HO]3b[*\ta%\u0001\u0003bW.\f\u0017B\u0001\u0015\"\u0005\u0019\u0019v.\u001e:dKB\u0011!&L\u0007\u0002W)\u0011A&J\u0001\u0005kRLG.\u0003\u0002/W\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0007A*t'D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mE\u0012aAR;ukJ,\u0007C\u0001\u001d:\u001b\u0005\u0019\u0013B\u0001\u001e$\u0005!IuJU3tk2$\b\"\u0002\u001f\u0003\u0001\u0004i\u0014!\u00018\u0011\u0005yzT\"A\u001a\n\u0005\u0001\u001b$aA%oi\")!I\u0001a\u0001{\u0005Q!-\u001e4gKJ\u001c\u0016N_3\t\u000b\u0011\u0013\u0001\u0019A#\u0002\u00175\f\u0007PR5mKNK'0\u001a\t\u0003}\u0019K!aR\u001a\u0003\t1{gn\u001a\u0005\b\u0013\n\u0001\n\u00111\u0001>\u0003)yW\u000f\u001e\"vMNK'0Z\u0001\u001bi\u0016\u001cHOQ;gM\u0016\u0014X\r\u001a$m_^$C-\u001a4bk2$H\u0005N\u000b\u0002\u0019*\u0012Q(T\u0016\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\nk:\u001c\u0007.Z2lK\u0012T!aU\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002V!\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\tML'0Z\u000b\u0002{\u0005)1/\u001b>fA\u00059\u0001/\u0019;uKJtW#A\u0015\u0002\u0011A\fG\u000f^3s]\u0002\naa]8ve\u000e,W#A\u0010\u0002\u000fM|WO]2fA\u0001")
public class FileBufferedDataFlowTest
extends AsyncFlatSpec {
    private final int size;
    private final ByteString pattern = ByteString$.MODULE$.apply((byte[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.size()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)FileBufferedDataFlowTest.$anonfun$pattern$1(BoxesRunTime.unboxToInt((Object)x$1))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte()));
    private final Source<ByteString, Future<IOResult>> source = this.testBufferedFlow(this.size(), 10, 100L, 10);

    public Source<ByteString, Future<IOResult>> testBufferedFlow(int n, int bufferSize, long maxFileSize, int outBufSize) {
        Graph buffer = FileBufferedFlow$.MODULE$.create(bufferSize, maxFileSize, outBufSize);
        return ((Source)Source$.MODULE$.fromIterator((Function0 & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).iterator()).map((Function1 & Serializable & scala.Serializable)b -> ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)BoxesRunTime.unboxToInt((Object)b)})))).viaMat(buffer, Keep$.MODULE$.right()).async();
    }

    public int testBufferedFlow$default$4() {
        return 8192;
    }

    public int size() {
        return this.size;
    }

    public ByteString pattern() {
        return this.pattern;
    }

    public Source<ByteString, Future<IOResult>> source() {
        return this.source;
    }

    public static final /* synthetic */ byte $anonfun$pattern$1(int x$1) {
        return (byte)x$1;
    }

    public FileBufferedDataFlowTest() {
        this.size = 100;
        this.it().should("buffer bytes flow with fixed downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> ((Source)this.source().map((Function1 & Serializable & scala.Serializable)x -> {
            Thread.sleep(10L);
            return x;
        })).async().runReduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23));
        this.it().should("buffer bytes flow with no downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> this.source().runReduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.$plus$plus(x$5), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.it().should("buffer bytes flow with variable downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> ((Source)this.source().map((Function1 & Serializable & scala.Serializable)x -> {
            Thread.sleep(Random$.MODULE$.nextInt(101));
            return x;
        })).async().runReduce((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.$plus$plus(x$7), StreamsEnv$.MODULE$.mat()).map((Function1 & Serializable & scala.Serializable)b -> {
            ByteString $org_scalatest_assert_macro_left = this.pattern();
            ByteString $org_scalatest_assert_macro_right = b;
            ByteString byteString = $org_scalatest_assert_macro_left;
            ByteString byteString2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(byteString != null ? !byteString.equals(byteString2) : byteString2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.it().should("return correct IOResult").in((Function0 & Serializable & scala.Serializable)() -> ((Future)this.source().to((Graph)Sink$.MODULE$.ignore()).run(StreamsEnv$.MODULE$.mat())).map((Function1 & Serializable & scala.Serializable)r -> {
            long $org_scalatest_assert_macro_left = r.count();
            int $org_scalatest_assert_macro_right = this.size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.it().should("buffer bytes from flow with variable upstream/downstream timeout").in((Function0 & Serializable & scala.Serializable)() -> {
            int fileSize = 1000000;
            int bufferSize = 1024;
            int maxFileSize = 0x100000;
            int outBufSize = 2048;
            Source source = (Source)Source$.MODULE$.fromIterator((Function0 & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), fileSize).iterator()).map((Function1 & Serializable & scala.Serializable)b -> ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)BoxesRunTime.unboxToInt((Object)b)})));
            Graph buffer = FileBufferedFlow$.MODULE$.create(bufferSize, (long)maxFileSize, outBufSize);
            VolatileDoubleRef size = VolatileDoubleRef.create((double)0.0);
            return ((Future)((Source)((Source)source.aggregateWithBoundary((Function0 & Serializable & scala.Serializable)() -> ByteString$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(abs, bs) -> new Tuple2((Object)abs.$plus$plus(bs), (Object)BoxesRunTime.boxToBoolean((abs.size() + bs.size() > 512 ? 1 : 0) != 0)), (Function1 & Serializable & scala.Serializable)x -> (ByteString)Predef$.MODULE$.identity(x), (Option)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)b -> {
                size$1.elem += (double)b.size();
                return b;
            }).map((Function1 & Serializable & scala.Serializable)b -> {
                block0: {
                    double r = size$1.elem / (double)fileSize;
                    if (!(r < 0.25) && (!(r > 0.5) || !(r < 0.75))) break block0;
                    Thread.sleep(Random$.MODULE$.nextInt(30));
                }
                return b;
            })).async().via(buffer).async().map((Function1 & Serializable & scala.Serializable)b -> {
                block0: {
                    double r = size$1.elem / (double)fileSize;
                    if (!(r > 0.25 && r < 0.5) && !(r > 0.75)) break block0;
                    Thread.sleep(Random$.MODULE$.nextInt(30));
                }
                return b;
            })).runWith((Graph)AppFileStreamer$.MODULE$.sha256sink(this.executionContext()), StreamsEnv$.MODULE$.mat())).zip((Future)source.runWith((Graph)AppFileStreamer$.MODULE$.sha256sink(this.executionContext()), StreamsEnv$.MODULE$.mat())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String hash1 = (String)tuple2._1();
                    String hash2 = (String)tuple2._2();
                    String $org_scalatest_assert_macro_left = hash1;
                    String $org_scalatest_assert_macro_right = hash2;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
                }
                throw new MatchError((Object)tuple2);
            }, this.executionContext());
        }, new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.it().should("fail with max file limit exceeded").in((Function0 & Serializable & scala.Serializable)() -> this.recoverToExceptionIf(((Source)this.testBufferedFlow(100, 10, 10L, this.testBufferedFlow$default$4()).map((Function1 & Serializable & scala.Serializable)b -> {
            Thread.sleep(10L);
            return b;
        })).addAttributes(Attributes$.MODULE$.inputBuffer(1, 1)).run(StreamsEnv$.MODULE$.mat()), ClassTag$.MODULE$.apply(InsufficientStorageException.class), this.executionContext(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, this.executionContext()), new Position("FileBufferedDataFlowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }
}

