/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.Tag;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.mojoz.querease.ValueConverter$;
import org.wabase.BorerDatetimeEncoders$;
import org.wabase.Format$;
import scala.sys.package$;

public final class BorerDatetimeDecoders$ {
    public static BorerDatetimeDecoders$ MODULE$;
    private final Decoder<Timestamp> javaSqlTimestampDecoder;
    private final Decoder<Date> javaSqlDateDecoder;
    private final Decoder<Time> javaSqlTimeDecoder;
    private final Decoder<Instant> javaTimeInstantDecoder;
    private final Decoder<LocalDate> localDateDecoder;
    private final Decoder<LocalTime> localTimeDecoder;
    private final Decoder<LocalDateTime> localDateTimeDecoder;
    private final Decoder<OffsetDateTime> offsetDateTimeDecoder;
    private final Decoder<ZonedDateTime> zonedDateTimeDecoder;

    static {
        new BorerDatetimeDecoders$();
    }

    public Decoder<Timestamp> javaSqlTimestampDecoder() {
        return this.javaSqlTimestampDecoder;
    }

    public Decoder<Date> javaSqlDateDecoder() {
        return this.javaSqlDateDecoder;
    }

    public Decoder<Time> javaSqlTimeDecoder() {
        return this.javaSqlTimeDecoder;
    }

    public Decoder<Instant> javaTimeInstantDecoder() {
        return this.javaTimeInstantDecoder;
    }

    public Decoder<LocalDate> localDateDecoder() {
        return this.localDateDecoder;
    }

    public Decoder<LocalTime> localTimeDecoder() {
        return this.localTimeDecoder;
    }

    public Decoder<LocalDateTime> localDateTimeDecoder() {
        return this.localDateTimeDecoder;
    }

    public Decoder<OffsetDateTime> offsetDateTimeDecoder() {
        return this.offsetDateTimeDecoder;
    }

    public Decoder<ZonedDateTime> zonedDateTimeDecoder() {
        return this.zonedDateTimeDecoder;
    }

    private static final Timestamp toSqlTimestamp$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaSqlTimestamp());
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(46).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.sql.Timestamp").toString());
    }

    private static final Date toSqlDate$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaSqlDate());
        if (object instanceof Date) {
            Date date = (Date)object;
            return date;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(41).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.sql.Date").toString());
    }

    private static final Time toSqlTime$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaSqlTime());
        if (object instanceof Time) {
            Time time = (Time)object;
            return time;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(41).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.sql.Time").toString());
    }

    private static final Instant toInstant$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaTimeInstant());
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return instant;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(45).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.time.Instant").toString());
    }

    private static final OffsetDateTime toOffsetDateTime$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaTimeOffsetDateTime());
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(52).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.time.OffsetDateTime").toString());
    }

    private static final ZonedDateTime toZonedDateTime$1(Object v) {
        Object object = Format$.MODULE$.convertToType(v, ValueConverter$.MODULE$.ClassOfJavaTimeZonedDateTime());
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime;
        }
        if (object == null) {
            return null;
        }
        throw package$.MODULE$.error(new StringBuilder(51).append("Unexpected class ").append(object.getClass().getName()).append(", expected java.time.ZonedDateTime").toString());
    }

    private BorerDatetimeDecoders$() {
        MODULE$ = this;
        this.javaSqlTimestampDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toSqlTimestamp$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toSqlTimestamp$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Timestamp((long)(reader.readDouble() * (double)1000));
            }
            if (256 == n) {
                return new Timestamp((long)(reader.readDouble() * (double)1000));
            }
            throw reader.unexpectedDataItem("Timestamp");
        });
        this.javaSqlDateDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toSqlDate$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toSqlDate$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Date(reader.readLong() * 1000L);
            }
            if (8 == n ? true : 16 == n) {
                return new Date(reader.readLong() * 1000L);
            }
            throw reader.unexpectedDataItem("Date");
        });
        this.javaSqlTimeDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toSqlTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toSqlTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)BorerDatetimeEncoders$.MODULE$.TimeTag())) {
                return new Time((long)(reader.readDouble() * (double)1000));
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return new Time((long)(reader.readDouble() * (double)1000));
            }
            if (256 == n) {
                return new Time((long)(reader.readDouble() * (double)1000));
            }
            throw reader.unexpectedDataItem("Time");
        });
        this.javaTimeInstantDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toInstant$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toInstant$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000));
            }
            if (256 == n) {
                return Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000));
            }
            throw reader.unexpectedDataItem("Instant");
        });
        this.localDateDecoder = Decoder$.MODULE$.apply(r -> ((Date)r.apply(MODULE$.javaSqlDateDecoder())).toLocalDate());
        this.localTimeDecoder = Decoder$.MODULE$.apply(r -> ((Time)r.apply(MODULE$.javaSqlTimeDecoder())).toLocalTime());
        this.localDateTimeDecoder = Decoder$.MODULE$.apply(r -> ((Timestamp)r.apply(MODULE$.javaSqlTimestampDecoder())).toLocalDateTime());
        this.offsetDateTimeDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toOffsetDateTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toOffsetDateTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return BorerDatetimeDecoders$.toOffsetDateTime$1(Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000)));
            }
            if (256 == n) {
                return BorerDatetimeDecoders$.toOffsetDateTime$1(Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000)));
            }
            throw reader.unexpectedDataItem("OffsetDateTime");
        });
        this.zonedDateTimeDecoder = Decoder$.MODULE$.apply(reader -> {
            int n = reader.dataItem();
            if (2048 == n ? true : 1024 == n) {
                return BorerDatetimeDecoders$.toZonedDateTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.DateTimeString$.MODULE$)) {
                return BorerDatetimeDecoders$.toZonedDateTime$1(reader.readString());
            }
            if (reader.tryReadTag((Tag)Tag.EpochDateTime$.MODULE$)) {
                return BorerDatetimeDecoders$.toZonedDateTime$1(Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000)));
            }
            if (256 == n) {
                return BorerDatetimeDecoders$.toZonedDateTime$1(Instant.ofEpochMilli((long)(reader.readDouble() * (double)1000)));
            }
            throw reader.unexpectedDataItem("ZonedDateTime");
        });
    }
}

