/*
 * Decompiled with CFR 0.152.
 */
package org.wabase;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class PostgresTextFormat$ {
    public static PostgresTextFormat$ MODULE$;
    private final ByteString columnDelimiter;
    private final ByteString rowDelimiter;

    static {
        new PostgresTextFormat$();
    }

    public ByteString columnDelimiter() {
        return this.columnDelimiter;
    }

    public ByteString rowDelimiter() {
        return this.rowDelimiter;
    }

    public void writeString(String s, Writer out) {
        int pos;
        int len = s.length();
        boolean isPlain = true;
        for (pos = 0; isPlain && pos < len; ++pos) {
            char ch = s.charAt(pos);
            isPlain = ch > '\r' && ch != '\\';
        }
        if (isPlain) {
            out.write(s);
            return;
        }
        if (--pos > 0) {
            out.write(s.substring(0, pos));
        }
        while (pos < len) {
            char ch = s.charAt(pos);
            if (ch == '\\') {
                out.write("\\\\");
            } else if (ch > '\r') {
                out.write(ch);
            } else {
                String string;
                char c = ch;
                switch (c) {
                    case '\u0000': {
                        string = "\\000";
                        break;
                    }
                    case '\u0001': {
                        string = "\\001";
                        break;
                    }
                    case '\u0002': {
                        string = "\\002";
                        break;
                    }
                    case '\u0003': {
                        string = "\\003";
                        break;
                    }
                    case '\u0004': {
                        string = "\\004";
                        break;
                    }
                    case '\u0005': {
                        string = "\\005";
                        break;
                    }
                    case '\u0006': {
                        string = "\\006";
                        break;
                    }
                    case '\u0007': {
                        string = "\\007";
                        break;
                    }
                    case '\b': {
                        string = "\\b";
                        break;
                    }
                    case '\t': {
                        string = "\\t";
                        break;
                    }
                    case '\n': {
                        string = "\\n";
                        break;
                    }
                    case '\u000b': {
                        string = "\\v";
                        break;
                    }
                    case '\f': {
                        string = "\\f";
                        break;
                    }
                    case '\r': {
                        string = "\\r";
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                    }
                }
                String escaped = string;
                out.write(escaped);
            }
            ++pos;
        }
    }

    public void write(Object value2, Writer out) {
        Object object = value2;
        if (object == null) {
            out.write("\\N");
            return;
        }
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)object)) {
            out.write("true");
            return;
        }
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)object)) {
            out.write("false");
            return;
        }
        this.writeString(object.toString(), out);
    }

    public void writeColumns(Seq<String> columnNames, Map<String, Object> data, Writer out) {
        BooleanRef first = BooleanRef.create((boolean)true);
        columnNames.foreach((Function1 & Serializable & scala.Serializable)columnName -> {
            PostgresTextFormat$.$anonfun$writeColumns$1(first, out, data, columnName);
            return BoxedUnit.UNIT;
        });
    }

    public void writeRow(Seq<String> columnNames, Map<String, Object> data, Writer out) {
        this.writeColumns(columnNames, data, out);
        out.write("\r\n");
    }

    public ByteString encodeColumns(Seq<String> columnNames, Map<String, Object> data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        this.writeColumns(columnNames, data, out);
        out.close();
        return ByteString$.MODULE$.apply(baos.toByteArray());
    }

    public String decodeString(String s) {
        int pos;
        int len = s.length();
        boolean isPlain = true;
        for (pos = 0; isPlain && pos < len; ++pos) {
            char ch = s.charAt(pos);
            isPlain = ch != '\\';
        }
        if (isPlain) {
            return s;
        }
        String string = s;
        String string2 = "\\N";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return null;
        }
        CharArrayWriter out = new CharArrayWriter(len);
        if (--pos > 0) {
            out.write(s.substring(0, pos));
        }
        while (pos < len) {
            char ch = s.charAt(pos);
            if (ch == '\\') {
                int n;
                char ch2;
                char c = ch2 = s.charAt(++pos);
                block0 : switch (c) {
                    case '0': {
                        char ch3;
                        char c2 = ch3 = s.charAt(++pos);
                        if ('0' == c2) {
                            char ch4;
                            char c3 = ch4 = s.charAt(++pos);
                            switch (c3) {
                                case '0': {
                                    n = 0;
                                    break block0;
                                }
                                case '1': {
                                    n = 1;
                                    break block0;
                                }
                                case '2': {
                                    n = 2;
                                    break block0;
                                }
                                case '3': {
                                    n = 3;
                                    break block0;
                                }
                                case '4': {
                                    n = 4;
                                    break block0;
                                }
                                case '5': {
                                    n = 5;
                                    break block0;
                                }
                                case '6': {
                                    n = 6;
                                    break block0;
                                }
                                case '7': {
                                    n = 7;
                                    break block0;
                                }
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c3));
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c2));
                    }
                    case '\\': {
                        n = 92;
                        break;
                    }
                    case 'b': {
                        n = 8;
                        break;
                    }
                    case 't': {
                        n = 9;
                        break;
                    }
                    case 'n': {
                        n = 10;
                        break;
                    }
                    case 'v': {
                        n = 11;
                        break;
                    }
                    case 'f': {
                        n = 12;
                        break;
                    }
                    case 'r': {
                        n = 13;
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                    }
                }
                int escaped = n;
                out.write(escaped);
            } else {
                out.write(ch);
            }
            ++pos;
        }
        out.close();
        return out.toString();
    }

    public Map<String, String> decodeColumns(Seq<String> columnNames, ByteString record) {
        String s2 = record.utf8String();
        List values = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(s2)).split('\t'))).map((Function1 & Serializable & scala.Serializable)s -> MODULE$.decodeString((String)s), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        if (values.size() != columnNames.size()) {
            throw package$.MODULE$.error(new StringBuilder(50).append("Unexpected field count (").append(values.size()).append(" instead of ").append(columnNames.size()).append(") for record: ").append(s2).toString());
        }
        return ((TraversableOnce)columnNames.zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$writeColumns$1(BooleanRef first$1, Writer out$1, Map data$1, String columnName) {
        if (first$1.elem) {
            first$1.elem = false;
        } else {
            out$1.write(9);
        }
        MODULE$.write(data$1.getOrElse((Object)columnName, (Function0 & Serializable & scala.Serializable)() -> null), out$1);
    }

    private PostgresTextFormat$() {
        MODULE$ = this;
        this.columnDelimiter = ByteString$.MODULE$.apply("\t");
        this.rowDelimiter = ByteString$.MODULE$.apply("\r\n");
    }
}

