/*
 * Decompiled with CFR 0.152.
 */
package org.wabase.spreadsheet.xlsxml;

import java.io.Serializable;
import java.io.Writer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.wabase.Format$;
import org.wabase.spreadsheet.xlsxml.DATE_TIME$;
import org.wabase.spreadsheet.xlsxml.DataType;
import org.wabase.spreadsheet.xlsxml.NUMBER$;
import org.wabase.spreadsheet.xlsxml.STRING$;
import org.wabase.spreadsheet.xlsxml.Style;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001E\t\u00015!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u001d\t\u0004A1A\u0005\nIBaa\u000f\u0001!\u0002\u0013\u0019\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002*\u0001\t\u0003\u0019\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00021\u0001\t\u0003y\u0006\"B1\u0001\t\u0003\u0011\u0007b\u00026\u0001#\u0003%\ta\u001b\u0005\u0006m\u0002!\ta\u0018\u0005\u0006o\u0002!\ta\u0018\u0005\u0006q\u0002!\ta\u0018\u0005\u0006s\u0002!\ta\u0018\u0002\u000f12\u001c\b,\u001c7TiJ,\u0017-\\3s\u0015\t\u00112#\u0001\u0004yYNDX\u000e\u001c\u0006\u0003)U\t1b\u001d9sK\u0006$7\u000f[3fi*\u0011acF\u0001\u0007o\u0006\u0014\u0017m]3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\ryW\u000f^\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003S>T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t1qK]5uKJ\fAa\\;uA\u00051A(\u001b8jiz\"\"A\f\u0019\u0011\u0005=\u0002Q\"A\t\t\u000b\u0005\u001a\u0001\u0019A\u0012\u0002/ad7\u000fW7m\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014X#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014A\u00024pe6\fGO\u0003\u00029O\u0005!A/[7f\u0013\tQTGA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\f\u0001\u0004\u001f7t16dG)\u0019;f)&lWMR8s[\u0006$H/\u001a:!\u00035\u0019H/\u0019:u/>\u00148NY8pWR\u0011a(\u0011\t\u00039}J!\u0001Q\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0007gRLH.Z:\u0011\u0007\u0011cuJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001*G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!aS\u000f\u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\u0004'\u0016\f(BA&\u001e!\ty\u0003+\u0003\u0002R#\t)1\u000b^=mK\u0006q1\u000f^1si^{'o[:iK\u0016$HC\u0001 U\u0011\u0015)v\u00011\u0001W\u0003\u0011q\u0017-\\3\u0011\u0005][fB\u0001-Z!\t1U$\u0003\u0002[;\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQV$\u0001\u0006ti\u0006\u0014H\u000fV1cY\u0016,\u0012AP\u0001\tgR\f'\u000f\u001e*po\u0006!1-\u001a7m)\rq4\r\u001b\u0005\u0006I*\u0001\r!Z\u0001\u0006m\u0006dW/\u001a\t\u00039\u0019L!aZ\u000f\u0003\u0007\u0005s\u0017\u0010C\u0004j\u0015A\u0005\t\u0019A(\u0002\u000bM$\u0018\u0010\\3\u0002\u001d\r,G\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\tAN\u000b\u0002P[.\na\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003gv\t!\"\u00198o_R\fG/[8o\u0013\t)\bOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa!\u001a8e%><\u0018\u0001C3oIR\u000b'\r\\3\u0002\u0019\u0015tGmV8sWNDW-\u001a;\u0002\u0017\u0015tGmV8sW\n|wn\u001b")
public class XlsXmlStreamer {
    private final Writer out;
    private final DateTimeFormatter xlsXmlDateTimeFormatter;

    public Writer out() {
        return this.out;
    }

    private DateTimeFormatter xlsXmlDateTimeFormatter() {
        return this.xlsXmlDateTimeFormatter;
    }

    public void startWorkbook(Seq<Style> styles) {
        this.out().write(new StringOps(Predef$.MODULE$.augmentString("  |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                   |<?mso-application progid=\"Excel.Sheet\"?>\n                   |<Workbook xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n                   |          xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\">\n                   |")).stripMargin());
        if (styles != null && !styles.isEmpty()) {
            this.out().write(new StringOps(Predef$.MODULE$.augmentString("|  <Styles>\n                   |")).stripMargin());
            styles.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.write(this.out());
                return BoxedUnit.UNIT;
            });
            this.out().write(new StringOps(Predef$.MODULE$.augmentString("|  </Styles>\n                   |")).stripMargin());
            return;
        }
    }

    public void startWorksheet(String name) {
        this.out().write("  <Worksheet ss:Name=\"");
        this.out().write(name);
        this.out().write("\">\n");
    }

    public void startTable() {
        this.out().write("    <Table>\n");
    }

    public void startRow() {
        this.out().write("      <Row>");
    }

    public void cell(Object value2, Style style) {
        DataType t = null;
        String v = null;
        Object object = value2;
        if (object == null) {
        } else if (object instanceof Number) {
            Number number = (Number)object;
            t = NUMBER$.MODULE$;
            v = number.toString();
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            t = DATE_TIME$.MODULE$;
            v = localDate.atStartOfDay().format(this.xlsXmlDateTimeFormatter());
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            t = DATE_TIME$.MODULE$;
            v = localDateTime.format(this.xlsXmlDateTimeFormatter());
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            t = DATE_TIME$.MODULE$;
            v = timestamp.toLocalDateTime().format(this.xlsXmlDateTimeFormatter());
        } else if (object instanceof Date) {
            Date date = (Date)object;
            t = DATE_TIME$.MODULE$;
            v = date.toLocalDate().atStartOfDay().format(this.xlsXmlDateTimeFormatter());
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            t = DATE_TIME$.MODULE$;
            v = LocalDateTime.ofInstant(instant, ZoneOffset.UTC).format(this.xlsXmlDateTimeFormatter());
        } else if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            t = DATE_TIME$.MODULE$;
            v = LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).format(this.xlsXmlDateTimeFormatter());
        } else {
            t = STRING$.MODULE$;
            v = Format$.MODULE$.xmlEscape(object.toString());
        }
        this.out().write("<Cell");
        if (style != null) {
            this.out().write(" ss:StyleID=\"");
            this.out().write(style.id());
            this.out().write("\"");
        }
        this.out().write(">");
        if (v != null && v.length() > 0) {
            this.out().write("<Data ss:Type=\"");
            this.out().write(t.name());
            this.out().write("\">");
            this.out().write(v);
            this.out().write("</Data>");
        }
        this.out().write("</Cell>");
    }

    public Style cell$default$2() {
        return null;
    }

    public void endRow() {
        this.out().write("</Row>\n");
    }

    public void endTable() {
        this.out().write("    </Table>\n");
    }

    public void endWorksheet() {
        this.out().write("  </Worksheet>\n");
    }

    public void endWorkbook() {
        this.out().write("</Workbook>\n");
    }

    public XlsXmlStreamer(Writer out) {
        this.out = out;
        this.xlsXmlDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }
}

