/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.mrpopo.mojos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

@Mojo(name="mrpopo")
public class MrPopoMojo
extends AbstractMojo {
    @Parameter
    protected String url = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommit() throws MojoExecutionException, MojoFailureException {
        String commit;
        block20: {
            commit = null;
            File head = new File(".git", "HEAD");
            FileReader reader = null;
            BufferedReader br = null;
            if (!head.exists()) {
                throw new MojoExecutionException("This is not a Git repository");
            }
            try {
                reader = new FileReader(head);
                br = new BufferedReader(reader);
                String line = br.readLine();
                int index = line.indexOf(":");
                if (index == -1) {
                    commit = line;
                    break block20;
                }
                String refName = line.substring(index + 1).trim();
                File ref = new File(".git", refName);
                BufferedReader refReader = new BufferedReader(new FileReader(ref));
                try {
                    commit = refReader.readLine().trim();
                }
                finally {
                    refReader.close();
                }
            }
            catch (Exception e) {
                MojoExecutionException ex = new MojoExecutionException("Error reading the .git/logs/HEAD file", e);
                throw ex;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        MojoExecutionException ex = new MojoExecutionException("Error closing the buffer", (Exception)e);
                        throw ex;
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        MojoExecutionException ex = new MojoExecutionException("Error closing the reader", (Exception)e);
                        throw ex;
                    }
                }
            }
        }
        return commit;
    }

    public String getReference() throws MojoExecutionException, MojoFailureException {
        File gitWorkDir = new File(".");
        String reference = null;
        try {
            Git git = Git.open((File)gitWorkDir);
            Repository repo = git.getRepository();
            reference = repo.getFullBranch();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error resolving the branch ", (Exception)e);
        }
        return reference;
    }

    public String getRemote() throws MojoExecutionException, MojoFailureException {
        File gitWorkDir = new File(".");
        String url = null;
        StoredConfig config = null;
        try {
            Git git = Git.open((File)gitWorkDir);
            Repository repo = git.getRepository();
            config = repo.getConfig();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error resolving the branch ", (Exception)e);
        }
        url = config.getString("remote", "origin", "url");
        int index = url.indexOf("github.com");
        if (index == -1) {
            throw new MojoExecutionException("The url must belong to Github");
        }
        return url;
    }

    public boolean conventionsApplied(InputStream is) throws IOException {
        boolean conventionsApplied = false;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        JsonNode response = mapper.readTree(is);
        JsonNode files = response.get("files");
        if (files.isArray()) {
            Iterator it = files.getElements();
            conventionsApplied = it.hasNext();
            if (conventionsApplied) {
                System.out.println("=====================================");
            }
            while (it.hasNext()) {
                this.getLog().info((CharSequence)((JsonNode)it.next()).asText());
            }
            if (conventionsApplied) {
                System.out.println("=====================================");
            }
        }
        return conventionsApplied;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.url == null) {
            throw new MojoExecutionException("The url parameter is null");
        }
        String reference = this.getReference();
        String remote = this.getRemote();
        String commit = this.getCommit();
        InputStream is = null;
        boolean conventionsApplied = false;
        String fullURL = this.url = this.url + "?remote=" + remote;
        fullURL = fullURL + "&&reference=" + reference;
        fullURL = fullURL + "&&commit=" + commit;
        try {
            URL address = new URL(fullURL);
            is = address.openStream();
            conventionsApplied = this.conventionsApplied(is);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading the mrpopo response", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    MojoExecutionException ex = new MojoExecutionException("Error closing the input stream", (Exception)e);
                    throw ex;
                }
            }
        }
        if (conventionsApplied) {
            throw new MojoFailureException("There are conventions violated. The next build will be automatically fixed");
        }
    }
}

