/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.mrpopo.mojos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

@Mojo(name="mrpopo")
public class MrPopoMojo
extends AbstractMojo {
    @Parameter
    protected String url = null;

    private String getReference() throws MojoExecutionException, MojoFailureException {
        String reference;
        block18: {
            File head = new File(".git", "HEAD");
            FileReader reader = null;
            BufferedReader br = null;
            reference = null;
            if (!head.exists()) {
                throw new MojoExecutionException("This is not a Git repository");
            }
            try {
                reader = new FileReader(head);
                br = new BufferedReader(reader);
                String line = br.readLine();
                if (line.length() <= 0) break block18;
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    parts[1] = parts[1].trim();
                    if (parts[1].startsWith("refs/heads/")) {
                        reference = parts[1];
                        break block18;
                    }
                    throw new MojoExecutionException("Invalid Ref");
                }
                throw new MojoExecutionException("Invalid Head file");
            }
            catch (Exception e) {
                MojoExecutionException ex = new MojoExecutionException("Error reading the .git/HEAD file", e);
                throw ex;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        MojoExecutionException ex = new MojoExecutionException("Error closing the buffer", (Exception)e);
                        throw ex;
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        MojoExecutionException ex = new MojoExecutionException("Error closing the reader", (Exception)e);
                        throw ex;
                    }
                }
            }
        }
        return reference;
    }

    public String getRemote() throws MojoExecutionException, MojoFailureException {
        String remote = null;
        File config = new File(".git", "config");
        if (!config.exists()) {
            throw new MojoExecutionException("The .git/config file does not exist");
        }
        FileReader reader = null;
        BufferedReader br = null;
        try {
            boolean finish;
            reader = new FileReader(config);
            br = new BufferedReader(reader);
            String line = br.readLine();
            boolean bl = finish = line == null;
            while (!finish) {
                String cleanLine = line.trim();
                if (cleanLine.startsWith("url = ")) {
                    finish = true;
                    remote = cleanLine.substring("url = ".length());
                }
                line = br.readLine();
                finish = finish || line == null;
            }
        }
        catch (Exception e) {
            MojoExecutionException ex = new MojoExecutionException("Error reading the .git/HEAD file", e);
            throw ex;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    MojoExecutionException ex = new MojoExecutionException("Error closing the buffer", (Exception)e);
                    throw ex;
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    MojoExecutionException ex = new MojoExecutionException("Error closing the reader", (Exception)e);
                    throw ex;
                }
            }
        }
        return remote;
    }

    public boolean conventionsApplied(InputStream is) throws IOException {
        boolean conventionsApplied = false;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        JsonNode response = mapper.readTree(is);
        JsonNode files = response.get("files");
        if (files.isArray()) {
            Iterator it = files.getElements();
            conventionsApplied = it.hasNext();
            if (conventionsApplied) {
                System.out.println("=====================================");
            }
            while (it.hasNext()) {
                this.getLog().info((CharSequence)((JsonNode)it.next()).asText());
            }
            if (conventionsApplied) {
                System.out.println("=====================================");
            }
        }
        return conventionsApplied;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.url == null) {
            throw new MojoExecutionException("The url parameter is null");
        }
        String reference = this.getReference();
        String remote = this.getRemote();
        InputStream is = null;
        boolean conventionsApplied = false;
        try {
            URL address = new URL(this.url + "?reference=" + reference + "&&remote=" + remote);
            is = address.openStream();
            conventionsApplied = this.conventionsApplied(is);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading the mrpopo response", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    MojoExecutionException ex = new MojoExecutionException("Error closing the input stream", (Exception)e);
                    throw ex;
                }
            }
        }
        if (conventionsApplied) {
            throw new MojoFailureException("There are conventions violated. The next build will be automatically fixed");
        }
    }
}

