/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.merger;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.merger.CollectionUtil;
import org.walkmod.merger.IdentificableNode;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.MergeEngineAware;
import org.walkmod.merger.Mergeable;
import org.walkmod.merger.ObjectMergePolicy;

public class AppendMergePolicy<T extends IdentificableNode>
extends ObjectMergePolicy<T>
implements MergeEngineAware {
    private MergeEngine mergeConfiguration;

    @Override
    public void apply(T localObject, T remoteObject, List<T> resultList) {
        if (localObject == null) {
            resultList.add(remoteObject);
        } else {
            if (localObject instanceof Mergeable) {
                ((Mergeable)localObject).merge(remoteObject, this.mergeConfiguration);
            }
            resultList.add(localObject);
        }
    }

    @Override
    public void setMergeEngine(MergeEngine mergeConfiguration) {
        this.mergeConfiguration = mergeConfiguration;
    }

    @Override
    public MergeEngine getMergeEngine() {
        return this.mergeConfiguration;
    }

    @Override
    public T apply(T localObject, T remoteObject) {
        if (localObject == null) {
            return remoteObject;
        }
        if (localObject instanceof Mergeable) {
            ((Mergeable)localObject).merge(remoteObject, this.mergeConfiguration);
        }
        return localObject;
    }

    @Override
    public void apply(List<T> localList, List<T> remoteList, List resultList) {
        if (remoteList != null) {
            LinkedList updatedLocalObjects = new LinkedList();
            LinkedList addedRemoteObjects = new LinkedList();
            for (IdentificableNode remoteObject : remoteList) {
                Comparator<?> comparator;
                IdentificableNode localObject = (IdentificableNode)CollectionUtil.findObject(localList, remoteObject, comparator = remoteObject.getIdentityComparator());
                if (localObject != null) {
                    this.apply(localObject, remoteObject, updatedLocalObjects);
                    continue;
                }
                this.apply(localObject, remoteObject, addedRemoteObjects);
            }
            if (localList != null) {
                for (IdentificableNode local : localList) {
                    resultList.add(local);
                }
            }
            for (IdentificableNode remoteAdded : addedRemoteObjects) {
                resultList.add(remoteAdded);
            }
        } else {
            resultList.addAll(localList);
        }
    }
}

