/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.merger;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.walkmod.merger.AppendMergePolicy;
import org.walkmod.merger.MergeEngineAware;
import org.walkmod.merger.MergePolicy;
import org.walkmod.merger.Mergeable;
import org.walkmod.merger.UnmodifyMergePolicy;

public class MergeEngine {
    private Map<Class<?>, MergePolicy> map;
    private MergePolicy<?> defaultObjectMergePolicy = new AppendMergePolicy();
    private MergePolicy<?> defaultTypeMergePolicy = new UnmodifyMergePolicy();

    public void setPolicyConfiguration(Map<Class<?>, MergePolicy> map) {
        this.map = map;
    }

    public MergeEngine() {
        this.map = new HashMap();
    }

    public MergePolicy getMergePolicy(Object obj) {
        return this.getMergePolicy(obj.getClass());
    }

    public MergePolicy getMergePolicy(Class<?> clazz) {
        if (this.map.containsKey(clazz)) {
            return this.map.get(clazz);
        }
        if (clazz.equals(Object.class)) {
            return null;
        }
        return this.getMergePolicy(clazz.getSuperclass());
    }

    public Object apply(Object localObject, Object remoteObject, Class<?> clazz) {
        MergePolicy<?> policy = this.getMergePolicy(clazz);
        if (policy == null) {
            policy = Mergeable.class.isAssignableFrom(clazz) ? this.defaultObjectMergePolicy : this.defaultTypeMergePolicy;
        }
        return policy.apply(localObject, remoteObject);
    }

    public void apply(List localList, List remoteList, List resultList, Class<?> genericClass) {
        if (localList == null && remoteList == null) {
            return;
        }
        if (localList != null && localList.isEmpty() && remoteList != null && remoteList.isEmpty()) {
            return;
        }
        MergePolicy<?> policy = this.getMergePolicy(genericClass);
        if (policy == null) {
            policy = Mergeable.class.isAssignableFrom(genericClass) ? this.defaultObjectMergePolicy : this.defaultTypeMergePolicy;
        }
        if (policy instanceof MergeEngineAware) {
            ((MergeEngineAware)((Object)policy)).setMergeEngine(this);
        }
        Map<Class<?>, List<?>> localSubTypesMap = this.buildSubTypesListMap(localList, genericClass);
        Map<Class<?>, List<?>> remoteSubTypesMap = this.buildSubTypesListMap(remoteList, genericClass);
        Set<Class<?>> remoteKeys = remoteSubTypesMap.keySet();
        for (Class<?> clazz : remoteKeys) {
            if (localSubTypesMap.containsKey(clazz)) continue;
            localSubTypesMap.put(clazz, null);
        }
        for (Map.Entry entry : localSubTypesMap.entrySet()) {
            this.apply((List)entry.getValue(), remoteSubTypesMap.get(entry.getKey()), resultList, (Class)entry.getKey());
        }
        policy.apply(localList, remoteList, resultList);
    }

    private <T> Map<Class<?>, List<?>> buildSubTypesListMap(List<T> originalList, Class<?> genericClass) {
        LinkedHashMap subTypesLists = new LinkedHashMap();
        LinkedList<T> removalList = new LinkedList<T>();
        if (originalList != null) {
            for (T localObject : originalList) {
                if (localObject.getClass().equals(genericClass)) continue;
                LinkedList<T> list = (LinkedList<T>)subTypesLists.get(localObject.getClass());
                if (list == null) {
                    list = new LinkedList<T>();
                    subTypesLists.put(localObject.getClass(), list);
                }
                list.add(localObject);
                removalList.add(localObject);
            }
            originalList.removeAll(removalList);
        }
        return subTypesLists;
    }

    public MergePolicy<?> getDefaultObjectMergePolicy() {
        return this.defaultObjectMergePolicy;
    }

    public void setDefaultObjectMergePolicy(MergePolicy<?> defaultObjectMergePolicy) {
        this.defaultObjectMergePolicy = defaultObjectMergePolicy;
    }

    public MergePolicy<?> getDefaultTypeMergePolicy() {
        return this.defaultTypeMergePolicy;
    }

    public void setDefaultTypeMergePolicy(MergePolicy<?> defaultTypeMergePolicy) {
        this.defaultTypeMergePolicy = defaultTypeMergePolicy;
    }
}

