/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.buildsupport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.buildsupport.AsmClassReader;
import org.spockframework.buildsupport.SpecClassFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecClassFileFinder {
    public List<File> findRunnableSpecs(File baseDir) throws IOException {
        if (!baseDir.isDirectory()) {
            throw new FileNotFoundException(String.format("directory %s not found", baseDir));
        }
        ArrayList<File> specs = new ArrayList<File>();
        this.doFindRunnableSpecs(baseDir, specs);
        Collections.sort(specs);
        return specs;
    }

    private void doFindRunnableSpecs(File dir, List<File> foundSpecs) throws IOException {
        for (File path : dir.listFiles()) {
            if (path.isDirectory()) {
                this.doFindRunnableSpecs(path, foundSpecs);
                continue;
            }
            if (!this.isRunnableSpec(path)) continue;
            foundSpecs.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunnableSpec(File file) throws IOException {
        if (!file.getName().endsWith(".class") || !file.isFile()) {
            return false;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            SpecClassFileVisitor visitor = new SpecClassFileVisitor();
            AsmClassReader reader = new AsmClassReader(stream);
            reader.accept(visitor);
            boolean bl = visitor.isRunnableSpec();
            return bl;
        }
        finally {
            ((InputStream)stream).close();
        }
    }
}

