/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.ISpecVisitor;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spec
extends Node<Spec, ClassNode> {
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Method> methods = new ArrayList<Method>();
    private FixtureMethod initializerMethod;
    private FixtureMethod sharedInitializerMethod;
    private FixtureMethod setupMethod;
    private FixtureMethod cleanupMethod;
    private FixtureMethod setupSpecMethod;
    private FixtureMethod cleanupSpecMethod;

    public Spec(ClassNode code) {
        super(null, code);
        this.setName(code.getName());
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public FixtureMethod getInitializerMethod() {
        return this.initializerMethod;
    }

    public void setInitializerMethod(FixtureMethod method) {
        this.initializerMethod = method;
        this.methods.add(method);
    }

    public FixtureMethod getSharedInitializerMethod() {
        return this.sharedInitializerMethod;
    }

    public void setSharedInitializerMethod(FixtureMethod method) {
        this.sharedInitializerMethod = method;
        this.methods.add(method);
    }

    public FixtureMethod getSetupMethod() {
        return this.setupMethod;
    }

    public void setSetupMethod(FixtureMethod method) {
        this.setupMethod = method;
        this.methods.add(method);
    }

    public FixtureMethod getCleanupMethod() {
        return this.cleanupMethod;
    }

    public void setCleanupMethod(FixtureMethod method) {
        this.cleanupMethod = method;
        this.methods.add(method);
    }

    public FixtureMethod getSetupSpecMethod() {
        return this.setupSpecMethod;
    }

    public void setSetupSpecMethod(FixtureMethod method) {
        this.setupSpecMethod = method;
        this.methods.add(method);
    }

    public FixtureMethod getCleanupSpecMethod() {
        return this.cleanupSpecMethod;
    }

    public void setCleanupSpecMethod(FixtureMethod method) {
        this.cleanupSpecMethod = method;
        this.methods.add(method);
    }

    @Override
    public void accept(ISpecVisitor visitor) throws Exception {
        visitor.visitSpec(this);
        for (Field f : this.fields) {
            f.accept(visitor);
        }
        for (Method m : this.methods) {
            m.accept(visitor);
        }
        visitor.visitSpecAgain(this);
    }
}

