/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import org.spockframework.mock.DefaultInteraction;
import org.spockframework.mock.IMockInvocation;

class DefaultToStringInteraction
extends DefaultInteraction {
    public static final DefaultToStringInteraction INSTANCE = new DefaultToStringInteraction();

    private DefaultToStringInteraction() {
    }

    public String getText() {
        return "Object.toString() interaction";
    }

    public boolean matches(IMockInvocation invocation) {
        return invocation.getMethod().getName().equals("toString") && invocation.getMethod().getParameterTypes().isEmpty();
    }

    public Object accept(IMockInvocation invocation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Mock for type '");
        builder.append(invocation.getMockObject().getType().getSimpleName());
        builder.append("'");
        String name = invocation.getMockObject().getName();
        if (name != null) {
            builder.append(" named '");
            builder.append(name);
            builder.append("'");
        }
        return builder.toString();
    }
}

