/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.spockframework.mock.DefaultEqualsHashCodeToStringInteractions;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyOrDummyResponse
implements IDefaultResponse {
    public static final EmptyOrDummyResponse INSTANCE = new EmptyOrDummyResponse();

    private EmptyOrDummyResponse() {
    }

    @Override
    public Object respond(IMockInvocation invocation) {
        Object emptyWrapper;
        IMockInteraction interaction = DefaultEqualsHashCodeToStringInteractions.INSTANCE.match(invocation);
        if (interaction != null) {
            return interaction.accept(invocation);
        }
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return null;
        }
        if (returnType.isPrimitive()) {
            return ReflectionUtil.getDefaultValue(returnType);
        }
        if (returnType.isInterface()) {
            if (returnType == Iterable.class) {
                return new ArrayList();
            }
            if (returnType == Collection.class) {
                return new ArrayList();
            }
            if (returnType == List.class) {
                return new ArrayList();
            }
            if (returnType == Set.class) {
                return new HashSet();
            }
            if (returnType == Map.class) {
                return new HashMap();
            }
            if (returnType == Queue.class) {
                return new LinkedList();
            }
            if (returnType == SortedSet.class) {
                return new TreeSet();
            }
            if (returnType == SortedMap.class) {
                return new TreeMap();
            }
            if (returnType == CharSequence.class) {
                return "";
            }
            return this.createDummy(invocation);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (returnType.isEnum()) {
            ?[] enumConstants = returnType.getEnumConstants();
            return enumConstants.length > 0 ? enumConstants[0] : null;
        }
        if (CharSequence.class.isAssignableFrom(returnType)) {
            if (returnType == String.class) {
                return "";
            }
            if (returnType == StringBuilder.class) {
                return new StringBuilder();
            }
            if (returnType == StringBuffer.class) {
                return new StringBuffer();
            }
            if (returnType == GString.class) {
                return GString.EMPTY;
            }
        }
        if ((emptyWrapper = this.createEmptyWrapper(returnType)) != null) {
            return emptyWrapper;
        }
        Object emptyObject = this.createEmptyObject(returnType);
        if (emptyObject != null) {
            return emptyObject;
        }
        return this.createDummy(invocation);
    }

    private Object createEmptyWrapper(Class<?> type) {
        if (Number.class.isAssignableFrom(type)) {
            Method method = ReflectionUtil.getDeclaredMethodBySignature(type, "valueOf", String.class);
            if (method != null && method.getReturnType() == type) {
                return ReflectionUtil.invokeMethod(type, method, "0");
            }
            if (type == BigInteger.class) {
                return BigInteger.ZERO;
            }
            if (type == BigDecimal.class) {
                return BigDecimal.ZERO;
            }
            return null;
        }
        if (type == Boolean.class) {
            return false;
        }
        if (type == Character.class) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private Object createEmptyObject(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object createDummy(IMockInvocation invocation) {
        Class<?> type = invocation.getMethod().getReturnType();
        Specification spec = invocation.getMockObject().getSpecification();
        return spec.createMock("dummy", type, MockNature.STUB, GroovyObject.class.isAssignableFrom(type) ? MockImplementation.GROOVY : MockImplementation.JAVA, Collections.<String, Object>emptyMap(), null);
    }
}

