/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spockframework.runtime.extension.ExtensionAnnotation;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRunner {
    private final SpecInfo spec;
    private final List<IGlobalExtension> globalExtensions;
    private final Map<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension> localExtensions = new HashMap<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension>();

    public ExtensionRunner(SpecInfo spec, List<IGlobalExtension> globalExtensions) {
        this.spec = spec;
        this.globalExtensions = globalExtensions;
    }

    public void run() {
        this.runGlobalExtensions();
        this.runAnnotationDrivenExtensions();
    }

    private void runGlobalExtensions() {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions() {
        this.runAnnotationDrivenExtensions(this.spec);
        for (IAnnotationDrivenExtension extension : this.localExtensions.values()) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.runAnnotationDrivenExtensions(spec.getSuperSpec());
        this.doRunAnnotationDrivenExtensions(spec);
        for (FieldInfo field : spec.getFields()) {
            this.doRunAnnotationDrivenExtensions(field);
        }
        this.doRunAnnotationDrivenExtensions(spec.getSetupSpecMethod());
        this.doRunAnnotationDrivenExtensions(spec.getSetupMethod());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupMethod());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupSpecMethod());
        for (FeatureInfo feature : spec.getFeatures()) {
            this.doRunAnnotationDrivenExtensions(feature.getFeatureMethod());
        }
    }

    private void doRunAnnotationDrivenExtensions(NodeInfo<?, ?> node) {
        if (node.isStub()) {
            return;
        }
        for (Annotation ann : node.getReflection().getAnnotations()) {
            ExtensionAnnotation extAnn = ann.annotationType().getAnnotation(ExtensionAnnotation.class);
            if (extAnn == null) continue;
            IAnnotationDrivenExtension extension = this.getOrCreateExtension(extAnn.value());
            if (node instanceof SpecInfo) {
                extension.visitSpecAnnotation(ann, (SpecInfo)node);
                continue;
            }
            if (node instanceof MethodInfo) {
                MethodInfo method = (MethodInfo)node;
                if (method.getKind() == MethodKind.FEATURE) {
                    extension.visitFeatureAnnotation(ann, method.getFeature());
                    continue;
                }
                extension.visitFixtureAnnotation(ann, method);
                continue;
            }
            extension.visitFieldAnnotation(ann, (FieldInfo)node);
        }
    }

    private IAnnotationDrivenExtension getOrCreateExtension(Class<? extends IAnnotationDrivenExtension> clazz) {
        IAnnotationDrivenExtension result = this.localExtensions.get(clazz);
        if (result == null) {
            try {
                result = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ExtensionException("Failed to instantiate extension '%s'", e).withArgs(clazz);
            }
            catch (IllegalAccessException e) {
                throw new ExtensionException("No-arg constructor of extension '%s' is not public", e).withArgs(clazz);
            }
            this.localExtensions.put(clazz, result);
        }
        return result;
    }
}

