/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.runner.Description;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class JUnitDescriptionGenerator {
    private final SpecInfo spec;

    public JUnitDescriptionGenerator(SpecInfo spec) {
        this.spec = spec;
    }

    public void attach() {
        Description desc = Description.createSuiteDescription((Class)((Class)this.spec.getReflection()));
        this.spec.setDescription(desc);
        for (FeatureInfo feature : this.spec.getAllFeatures()) {
            this.describeFeature(feature);
        }
        for (MethodInfo fixtureMethod : this.spec.getAllFixtureMethods()) {
            this.describeMethod(fixtureMethod);
        }
    }

    public Description aggregate() {
        Description desc = this.spec.getDescription();
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            return desc;
        }
        for (FeatureInfo feature : this.spec.getAllFeaturesInExecutionOrder()) {
            if (feature.isExcluded() || feature.isReportIterations()) continue;
            desc.addChild(feature.getFeatureMethod().getDescription());
        }
        return desc;
    }

    private Description describeFeature(FeatureInfo feature) {
        Description desc = this.describeMethod(feature.getFeatureMethod());
        feature.setDescription(desc);
        if (feature.getDataProcessorMethod() != null) {
            feature.getDataProcessorMethod().setDescription(desc);
        }
        for (DataProviderInfo prov : feature.getDataProviders()) {
            prov.getDataProviderMethod().setDescription(desc);
        }
        return desc;
    }

    private Description describeMethod(MethodInfo method) {
        Annotation[] anns = method.getReflection() == null ? new Annotation[]{} : ((Method)method.getReflection()).getAnnotations();
        Description desc = Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)method.getName(), (Annotation[])anns);
        method.setDescription(desc);
        return desc;
    }
}

