/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IoUtil;
import org.spockframework.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunHistory
implements Comparable<SpecRunHistory> {
    private static final int MAX_CONFIDENCE = 5;
    private final String specName;
    private Data data = new Data();

    public SpecRunHistory(String specName) {
        this.specName = specName;
    }

    public String getSpecName() {
        return this.specName;
    }

    public void loadFromDisk() throws IOException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.getDataFile()));
        try {
            this.data = (Data)in.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                IOException io = new IOException("deserialization error");
                io.initCause(e);
                throw io;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisk() throws IOException {
        File file = this.getDataFile();
        IoUtil.createDirectory(file.getParentFile());
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        try {
            out.writeObject(this.data);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(out);
            throw throwable;
        }
        IoUtil.closeQuietly(out);
    }

    public void sortFeatures(SpecInfo spec) {
        spec.sortFeatures(new IFeatureSortOrder(){

            public int compare(FeatureInfo f1, FeatureInfo f2) {
                long duration2;
                Integer confidence1 = ((SpecRunHistory)SpecRunHistory.this).data.featureConfidences.get(f1.getName());
                if (confidence1 == null) {
                    return -1;
                }
                Integer confidence2 = ((SpecRunHistory)SpecRunHistory.this).data.featureConfidences.get(f2.getName());
                if (confidence2 == null) {
                    return 1;
                }
                if (!confidence1.equals(confidence2)) {
                    return confidence1 - confidence2;
                }
                long duration1 = ((SpecRunHistory)SpecRunHistory.this).data.featureDurations.get(f1.getName());
                return duration1 < (duration2 = ((SpecRunHistory)SpecRunHistory.this).data.featureDurations.get(f2.getName()).longValue()) ? -1 : 1;
            }
        });
    }

    @Override
    public int compareTo(SpecRunHistory other) {
        int confidenceDiff = this.data.specConfidence.compareTo(other.data.specConfidence);
        if (confidenceDiff != 0) {
            return confidenceDiff;
        }
        return this.data.specDuration < other.data.specDuration ? -1 : 1;
    }

    public void collectFeatureData(FeatureInfo feature, long duration, boolean failed) {
        this.data.featureDurations.put(feature.getName(), duration);
        Integer oldConfidence = this.data.featureConfidences.get(feature.getName());
        if (oldConfidence == null) {
            oldConfidence = 0;
        }
        int newConfidence = failed ? 0 : Math.min(5, oldConfidence + 1);
        this.data.featureConfidences.put(feature.getName(), newConfidence);
    }

    public void collectSpecData(SpecInfo spec, long duration) {
        this.data.specDuration = duration;
        this.removeObsoleteFeaturesFromData(spec);
        this.computeSpecConfidence();
    }

    private void removeObsoleteFeaturesFromData(SpecInfo spec) {
        List<FeatureInfo> features = spec.getAllFeatures();
        Set<String> featureNames = this.extractNames(features);
        this.data.featureConfidences.keySet().retainAll(featureNames);
        this.data.featureDurations.keySet().retainAll(featureNames);
    }

    private void computeSpecConfidence() {
        int totalConfidence = 0;
        for (int confidence : this.data.featureConfidences.values()) {
            totalConfidence += confidence;
        }
        int numFeatures = this.data.featureConfidences.size();
        this.data.specConfidence = numFeatures == 0 ? new BigDecimal(0) : new BigDecimal(totalConfidence).divide(new BigDecimal(numFeatures), MathContext.DECIMAL32);
    }

    private Set<String> extractNames(List<FeatureInfo> features) {
        HashSet<String> featureNames = new HashSet<String>(features.size());
        for (FeatureInfo feature : features) {
            featureNames.add(feature.getName());
        }
        return featureNames;
    }

    private File getDataFile() {
        return new File(TextUtil.join(File.separator, System.getProperty("user.home"), ".spock", "RunHistory", this.specName));
    }

    private static class Data
    implements Serializable {
        BigDecimal specConfidence = new BigDecimal(0);
        long specDuration = 0L;
        Map<String, Integer> featureConfidences = new HashMap<String, Integer>();
        Map<String, Long> featureDurations = new HashMap<String, Long>();

        private Data() {
        }
    }
}

