/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.builtin.AbstractRuleExtension;
import org.spockframework.runtime.extension.builtin.ClassRuleInterceptor;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class ClassRuleExtension
extends AbstractRuleExtension {
    public void visitSpec(SpecInfo spec) {
        if (classRuleClass == null) {
            return;
        }
        ArrayList<FieldInfo> ruleFields = new ArrayList<FieldInfo>();
        for (FieldInfo field : spec.getAllFields()) {
            if (!field.isAnnotationPresent(classRuleClass)) continue;
            this.checkIsSharedField(field);
            if (this.hasFieldType(field, testRuleClass)) {
                ruleFields.add(field);
                continue;
            }
            this.invalidFieldType(field);
        }
        if (!ruleFields.isEmpty()) {
            ClassRuleInterceptorInstaller.install(spec, ruleFields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassRuleInterceptorInstaller {
        private ClassRuleInterceptorInstaller() {
        }

        static void install(SpecInfo spec, List<FieldInfo> ruleFields) {
            spec.addInterceptor(new ClassRuleInterceptor(ruleFields));
        }
    }
}

