/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import org.codehaus.groovy.ast.ASTNode;
import org.spockframework.runtime.model.TextPosition;

public class TextRegion {
    public static final TextRegion NOT_AVAILABLE = new TextRegion(TextPosition.NOT_AVAILABLE, TextPosition.NOT_AVAILABLE);
    private final TextPosition start;
    private final TextPosition end;

    private TextRegion(TextPosition start, TextPosition end) {
        this.start = start;
        this.end = end;
    }

    public TextPosition getStart() {
        return this.start;
    }

    public TextPosition getEnd() {
        return this.end;
    }

    public boolean contains(TextPosition position) {
        return position.compareTo(this.start) >= 0 && position.compareTo(this.end) <= 0;
    }

    public TextRegion shiftVertically(int numLines) {
        return TextRegion.create(this.start.shiftVertically(numLines), this.end.shiftVertically(numLines));
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextRegion other = (TextRegion)obj;
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.start.hashCode() * 31 + this.end.hashCode();
    }

    public String toString() {
        return String.format("%s-%s", this.start, this.end);
    }

    public static TextRegion of(ASTNode node) {
        return TextRegion.create(TextPosition.startOf(node), TextPosition.endOf(node));
    }

    public static TextRegion create(TextPosition start, TextPosition end) {
        if (start == TextPosition.NOT_AVAILABLE || end == TextPosition.NOT_AVAILABLE) {
            return NOT_AVAILABLE;
        }
        return new TextRegion(start, end);
    }
}

