/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class IoUtil {
    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(Reader reader) throws IOException {
        String string;
        try {
            StringBuilder source = new StringBuilder();
            BufferedReader buffered = new BufferedReader(reader);
            String line = buffered.readLine();
            while (line != null) {
                source.append(line);
                source.append('\n');
                line = buffered.readLine();
            }
            string = source.toString();
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
        return string;
    }

    public static String getText(File path) throws IOException {
        return IoUtil.getText(new FileReader(path));
    }

    public static String getText(InputStream stream) throws IOException {
        return IoUtil.getText(new InputStreamReader(stream));
    }

    public static void createDirectory(File dir) throws IOException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        try {
            int read = in.read(buffer);
            while (read > 0) {
                out.write(buffer, 0, read);
                read = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in, out);
            throw throwable;
        }
        IoUtil.closeQuietly(in, out);
    }

    public static void copyFile(File source, File target) throws FileNotFoundException, IOException {
        if (!source.isFile()) {
            throw new IOException(String.format("Error copying file %s to %s; source file does not exist", source, target));
        }
        IoUtil.createDirectory(target.getParentFile());
        IoUtil.doCopyFile(source, target);
        IoUtil.checkSameSize(source, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File source, File target) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            in.getChannel().transferTo(0L, Long.MAX_VALUE, out.getChannel());
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in, out);
            throw throwable;
        }
        IoUtil.closeQuietly(in, out);
    }

    private static void checkSameSize(File source, File target) throws IOException {
        long toSize;
        long fromSize = source.length();
        if (fromSize != (toSize = target.length())) {
            throw new IOException(String.format("Error copying file %s to %s; source file size is %d, but target file size is %d", source, target, fromSize, toSize));
        }
    }
}

