/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.ConfigurationImpl;
import org.hibernate.validator.internal.engine.ValidatorContextImpl;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.engine.constraintdefinition.ConstraintDefinitionBuilderImpl;
import org.hibernate.validator.internal.engine.constraintdefinition.ConstraintDefinitionContribution;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.ProgrammaticMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.XmlMetaDataProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.constraintdefinition.ConstraintDefinitionContributor;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private static final Log log = LoggerFactory.make();
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ParameterNameProvider parameterNameProvider;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final Set<DefaultConstraintMapping> constraintMappings;
    private final ConstraintHelper constraintHelper;
    private final TypeResolutionHelper typeResolutionHelper;
    private final ExecutableHelper executableHelper;
    private final boolean failFast;
    private final XmlMetaDataProvider xmlMetaDataProvider;
    private final Map<ParameterNameProvider, BeanMetaDataManager> beanMetaDataManagerMap;
    private final List<ValidatedValueUnwrapper<?>> validatedValueHandlers;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.parameterNameProvider = configurationState.getParameterNameProvider();
        this.beanMetaDataManagerMap = Collections.synchronizedMap(new IdentityHashMap());
        this.constraintHelper = new ConstraintHelper();
        this.typeResolutionHelper = new TypeResolutionHelper();
        this.executableHelper = new ExecutableHelper(this.typeResolutionHelper);
        this.xmlMetaDataProvider = configurationState.getMappingStreams().isEmpty() ? null : new XmlMetaDataProvider(this.constraintHelper, this.parameterNameProvider, configurationState.getMappingStreams());
        Map properties = configurationState.getProperties();
        boolean tmpFailFast = false;
        ArrayList tmpValidatedValueHandlers = CollectionHelper.newArrayList(5);
        HashSet tmpConstraintMappings = CollectionHelper.newHashSet();
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getProgrammaticMappings().size() > 0) {
                tmpConstraintMappings.addAll(hibernateSpecificConfig.getProgrammaticMappings());
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
            tmpValidatedValueHandlers.addAll(hibernateSpecificConfig.getValidatedValueHandlers());
            this.registerCustomConstraintValidators(hibernateSpecificConfig, properties);
        }
        this.constraintMappings = Collections.unmodifiableSet(tmpConstraintMappings);
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(properties, tmpFailFast);
        tmpValidatedValueHandlers.addAll(this.getPropertyConfiguredValidatedValueHandlers(properties));
        this.validatedValueHandlers = Collections.unmodifiableList(tmpValidatedValueHandlers);
        this.constraintValidatorManager = new ConstraintValidatorManager(configurationState.getConstraintValidatorFactory());
    }

    public Validator getValidator() {
        return this.createValidator(this.constraintValidatorManager.getDefaultConstraintValidatorFactory(), this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.failFast, this.validatedValueHandlers);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorManager.getDefaultConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public List<ValidatedValueUnwrapper<?>> getValidatedValueHandlers() {
        return this.validatedValueHandlers;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateValidatorFactory.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this);
    }

    public void close() {
        this.constraintValidatorManager.clear();
        for (BeanMetaDataManager beanMetaDataManager : this.beanMetaDataManagerMap.values()) {
            beanMetaDataManager.clear();
        }
    }

    Validator createValidator(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ParameterNameProvider parameterNameProvider, boolean failFast, List<ValidatedValueUnwrapper<?>> validatedValueHandlers) {
        BeanMetaDataManager beanMetaDataManager;
        if (messageInterpolator instanceof ResourceBundleMessageInterpolator) {
            try {
                ResourceBundleMessageInterpolator.class.getClassLoader().loadClass("javax.el.ExpressionFactory");
            }
            catch (ClassNotFoundException e) {
                throw log.getMissingELDependenciesException();
            }
        }
        if (!this.beanMetaDataManagerMap.containsKey(parameterNameProvider)) {
            beanMetaDataManager = new BeanMetaDataManager(this.constraintHelper, this.executableHelper, parameterNameProvider, this.buildDataProviders(parameterNameProvider));
            this.beanMetaDataManagerMap.put(parameterNameProvider, beanMetaDataManager);
        } else {
            beanMetaDataManager = this.beanMetaDataManagerMap.get(parameterNameProvider);
        }
        return new ValidatorImpl(constraintValidatorFactory, messageInterpolator, traversableResolver, beanMetaDataManager, parameterNameProvider, this.typeResolutionHelper, validatedValueHandlers, this.constraintValidatorManager, failFast);
    }

    private List<MetaDataProvider> buildDataProviders(ParameterNameProvider parameterNameProvider) {
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (this.xmlMetaDataProvider != null) {
            metaDataProviders.add(this.xmlMetaDataProvider);
        }
        if (!this.constraintMappings.isEmpty()) {
            metaDataProviders.add(new ProgrammaticMetaDataProvider(this.constraintHelper, parameterNameProvider, this.constraintMappings));
        }
        return metaDataProviders;
    }

    private boolean checkPropertiesForFailFast(Map<String, String> properties, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = properties.get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw log.getInconsistentFailFastConfigurationException();
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }

    private List<ValidatedValueUnwrapper<?>> getPropertyConfiguredValidatedValueHandlers(Map<String, String> properties) {
        String propertyValue = properties.get("hibernate.validator.validated_value_handlers");
        if (propertyValue == null || propertyValue.isEmpty()) {
            return Collections.emptyList();
        }
        String[] handlerNames = propertyValue.split(",");
        ArrayList<ValidatedValueUnwrapper<?>> handlers = CollectionHelper.newArrayList(handlerNames.length);
        for (String handlerName : handlerNames) {
            Class handlerType = (Class)this.run(LoadClass.action(handlerName, ValidatorFactoryImpl.class));
            handlers.add((ValidatedValueUnwrapper<?>)this.run(NewInstance.action(handlerType, "validated value handler class")));
        }
        return handlers;
    }

    private List<ConstraintDefinitionContributor> getPropertyConfiguredConstraintDefinitionContributors(Map<String, String> properties) {
        String propertyValue = properties.get("hibernate.validator.constraint_definition_contributors");
        if (propertyValue == null || propertyValue.isEmpty()) {
            return Collections.emptyList();
        }
        String[] constraintDefinitionContributorNames = propertyValue.split(",");
        ArrayList<ConstraintDefinitionContributor> constraintDefinitionContributors = CollectionHelper.newArrayList(constraintDefinitionContributorNames.length);
        for (String fqcn : constraintDefinitionContributorNames) {
            Class contributorType = (Class)this.run(LoadClass.action(fqcn, ValidatorFactoryImpl.class));
            constraintDefinitionContributors.add((ConstraintDefinitionContributor)this.run(NewInstance.action(contributorType, "constraint definition contributor class")));
        }
        return constraintDefinitionContributors;
    }

    private void registerCustomConstraintValidators(ConfigurationImpl hibernateSpecificConfig, Map<String, String> properties) {
        for (ConstraintDefinitionContributor contributor : hibernateSpecificConfig.getConstraintDefinitionContributors()) {
            this.registerConstraintValidators(contributor);
        }
        for (ConstraintDefinitionContributor contributor : this.getPropertyConfiguredConstraintDefinitionContributors(properties)) {
            this.registerConstraintValidators(contributor);
        }
    }

    private <A extends Annotation> void registerConstraintValidators(ConstraintDefinitionContributor contributor) {
        ConstraintDefinitionBuilderImpl builder = new ConstraintDefinitionBuilderImpl();
        contributor.collectConstraintDefinitions(builder);
        List<ConstraintDefinitionContribution<?>> constraintDefinitionContributions = builder.getConstraintValidatorContributions();
        for (ConstraintDefinitionContribution<?> constraintDefinitionContribution : constraintDefinitionContributions) {
            Class<?> constraintType = constraintDefinitionContribution.getConstraintType();
            List constraintValidatorTypes = constraintDefinitionContribution.getConstraintValidators();
            this.constraintHelper.putValidatorClasses(constraintType, constraintValidatorTypes, constraintDefinitionContribution.keepDefaults());
        }
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

