/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ParameterDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ParameterMetaData
extends AbstractConstraintMetaData
implements Cascadable {
    private final GroupConversionHelper groupConversionHelper;
    private final int index;
    private final Set<MetaConstraint<?>> typeArgumentsConstraints;

    private ParameterMetaData(int index, String name, Type type, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentsConstraints, boolean isCascading, Map<Class<?>, Class<?>> groupConversions, UnwrapMode unwrapMode) {
        super(name, type, constraints, ElementKind.PARAMETER, isCascading, !constraints.isEmpty() || isCascading || !typeArgumentsConstraints.isEmpty(), unwrapMode);
        this.index = index;
        this.typeArgumentsConstraints = Collections.unmodifiableSet(typeArgumentsConstraints);
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        this.groupConversionHelper.validateGroupConversions(this.isCascading(), this.toString());
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    @Override
    public Set<MetaConstraint<?>> getTypeArgumentsConstraints() {
        return this.typeArgumentsConstraints;
    }

    public ParameterDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ParameterDescriptorImpl(this.getType(), this.index, this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.getGroupConversionDescriptors());
    }

    public static class Builder
    extends MetaDataBuilder {
        private final Type parameterType;
        private final int parameterIndex;
        private String name;
        private final Set<MetaConstraint<?>> typeArgumentsConstraints = CollectionHelper.newHashSet();

        public Builder(Class<?> beanClass, ConstrainedParameter constrainedParameter, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.parameterType = constrainedParameter.getType();
            this.parameterIndex = constrainedParameter.getIndex();
            this.add(constrainedParameter);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (constrainedElement.getKind() != ConstrainedElement.ConstrainedElementKind.PARAMETER) {
                return false;
            }
            return ((ConstrainedParameter)constrainedElement).getIndex() == this.parameterIndex;
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedParameter constrainedParameter = (ConstrainedParameter)constrainedElement;
            this.typeArgumentsConstraints.addAll(constrainedParameter.getTypeArgumentsConstraints());
            if (this.name == null) {
                this.name = constrainedParameter.getName();
            }
        }

        @Override
        public ParameterMetaData build() {
            return new ParameterMetaData(this.parameterIndex, this.name, this.parameterType, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.typeArgumentsConstraints, this.isCascading(), this.getGroupConversions(), this.unwrapMode());
        }
    }
}

