/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.AbstractJobExplorerFactoryBean;
import org.springframework.batch.core.explore.support.SimpleJobExplorer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MapJobExplorerFactoryBean
extends AbstractJobExplorerFactoryBean
implements InitializingBean {
    private MapJobRepositoryFactoryBean repositoryFactory;

    public MapJobExplorerFactoryBean(MapJobRepositoryFactoryBean repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public MapJobExplorerFactoryBean() {
    }

    public void setRepositoryFactory(MapJobRepositoryFactoryBean repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.repositoryFactory != null ? 1 : 0) != 0, (String)"A MapJobRepositoryFactoryBean must be provided");
        this.repositoryFactory.afterPropertiesSet();
    }

    @Override
    protected JobExecutionDao createJobExecutionDao() throws Exception {
        return this.repositoryFactory.getJobExecutionDao();
    }

    @Override
    protected JobInstanceDao createJobInstanceDao() throws Exception {
        return this.repositoryFactory.getJobInstanceDao();
    }

    @Override
    protected StepExecutionDao createStepExecutionDao() throws Exception {
        return this.repositoryFactory.getStepExecutionDao();
    }

    @Override
    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        return this.repositoryFactory.getExecutionContextDao();
    }

    public JobExplorer getObject() throws Exception {
        return new SimpleJobExplorer(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao(), this.createExecutionContextDao());
    }
}

