/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.builder;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilderException;
import org.springframework.batch.core.job.builder.JobBuilderHelper;
import org.springframework.batch.core.job.builder.JobFlowBuilder;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SimpleJobBuilder
extends JobBuilderHelper<SimpleJobBuilder> {
    private List<Step> steps = new ArrayList<Step>();
    private JobFlowBuilder builder;

    public SimpleJobBuilder(JobBuilderHelper<?> parent) {
        super(parent);
    }

    public Job build() {
        if (this.builder != null) {
            return ((FlowJobBuilder)this.builder.end()).build();
        }
        SimpleJob job = new SimpleJob(this.getName());
        super.enhance(job);
        job.setSteps(this.steps);
        try {
            job.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new JobBuilderException(e);
        }
        return job;
    }

    public SimpleJobBuilder start(Step step) {
        if (this.steps.isEmpty()) {
            this.steps.add(step);
        } else {
            this.steps.set(0, step);
        }
        return this;
    }

    public FlowBuilder.TransitionBuilder<FlowJobBuilder> on(String pattern) {
        Assert.state((this.steps.size() > 0 ? 1 : 0) != 0, (String)"You have to start a job with a step");
        for (Step step : this.steps) {
            if (this.builder == null) {
                this.builder = new JobFlowBuilder(new FlowJobBuilder(this), step);
                continue;
            }
            this.builder.next(step);
        }
        return this.builder.on(pattern);
    }

    public JobFlowBuilder start(JobExecutionDecider decider) {
        if (this.builder == null) {
            this.builder = new JobFlowBuilder(new FlowJobBuilder(this), decider);
        } else {
            this.builder.start(decider);
        }
        if (!this.steps.isEmpty()) {
            this.steps.remove(0);
        }
        for (Step step : this.steps) {
            this.builder.next(step);
        }
        return this.builder;
    }

    public JobFlowBuilder next(JobExecutionDecider decider) {
        for (Step step : this.steps) {
            if (this.builder == null) {
                this.builder = new JobFlowBuilder(new FlowJobBuilder(this), step);
                continue;
            }
            this.builder.next(step);
        }
        if (this.builder == null) {
            this.builder = new JobFlowBuilder(new FlowJobBuilder(this), decider);
        } else {
            this.builder.next(decider);
        }
        return this.builder;
    }

    public SimpleJobBuilder next(Step step) {
        this.steps.add(step);
        return this;
    }

    public FlowBuilder.SplitBuilder<FlowJobBuilder> split(TaskExecutor executor) {
        for (Step step : this.steps) {
            if (this.builder == null) {
                this.builder = new JobFlowBuilder(new FlowJobBuilder(this), step);
                continue;
            }
            this.builder.next(step);
        }
        if (this.builder == null) {
            this.builder = new JobFlowBuilder(new FlowJobBuilder(this));
        }
        return this.builder.split(executor);
    }
}

