/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Properties;
import javax.batch.runtime.context.JobContext;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.jsr.JsrJobContext;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class JsrJobContextFactoryBean
implements FactoryBean<JobContext> {
    private JobExecution jobExecution;
    @Autowired
    private BatchPropertyContext propertyContext;
    private static final ThreadLocal<JobContext> contextHolder = new ThreadLocal();

    public JobContext getObject() throws Exception {
        return this.getCurrent();
    }

    public Class<?> getObjectType() {
        return JobContext.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"A JobExecution is required");
        this.jobExecution = jobExecution;
    }

    public void setBatchPropertyContext(BatchPropertyContext propertyContext) {
        this.propertyContext = propertyContext;
    }

    public void close() {
        if (contextHolder.get() != null) {
            contextHolder.remove();
        }
    }

    private JobContext getCurrent() {
        if (contextHolder.get() == null) {
            JobExecution curJobExecution = null;
            if (StepSynchronizationManager.getContext() != null) {
                curJobExecution = StepSynchronizationManager.getContext().getStepExecution().getJobExecution();
            }
            if (curJobExecution != null) {
                this.jobExecution = curJobExecution;
            }
            if (this.jobExecution == null) {
                throw new FactoryBeanNotInitializedException("A JobExecution is required");
            }
            JsrJobContext jobContext = new JsrJobContext();
            jobContext.setJobExecution(this.jobExecution);
            if (this.propertyContext != null) {
                jobContext.setProperties(this.propertyContext.getJobProperties());
            } else {
                jobContext.setProperties(new Properties());
            }
            contextHolder.set(jobContext);
        }
        return contextHolder.get();
    }
}

