/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job.flow.support;

import java.util.Set;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.xml.SimpleFlowFactoryBean;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.jsr.job.flow.support.state.JsrStepState;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.StringUtils;

public class JsrFlow
extends SimpleFlow {
    private JsrStepState currentStep;

    public JsrFlow(String name) {
        super(name);
    }

    public String getMostRecentStepName() {
        if (this.currentStep != null) {
            return this.currentStep.getStep().getName();
        }
        return null;
    }

    @Override
    protected boolean isFlowContinued(State state, FlowExecutionStatus status, StepExecution stepExecution) {
        if (state instanceof SimpleFlowFactoryBean.DelegateState) {
            state = ((SimpleFlowFactoryBean.DelegateState)state).getState();
        }
        if (state instanceof JsrStepState) {
            this.currentStep = (JsrStepState)state;
        }
        return super.isFlowContinued(state, status, stepExecution);
    }

    @Override
    protected State nextState(String stateName, FlowExecutionStatus status, StepExecution stepExecution) throws FlowExecutionException {
        String stepName;
        ExecutionContext executionContext;
        State nextState = this.findState(stateName, status, stepExecution);
        if (stepExecution != null && (executionContext = stepExecution.getJobExecution().getExecutionContext()).containsKey("batch.stoppedStep") && stateName.endsWith(stepName = executionContext.getString("batch.stoppedStep")) && nextState != null && executionContext.containsKey("batch.restartStep") && StringUtils.hasText((String)executionContext.getString("batch.restartStep"))) {
            nextState = this.findState(stateName, new FlowExecutionStatus(status.getName() + ".RESTART"), stepExecution);
        }
        return nextState;
    }

    private State findState(String stateName, FlowExecutionStatus status, StepExecution stepExecution) throws FlowExecutionException {
        Set<StateTransition> set = this.getTransitionMap().get(stateName);
        if (set == null) {
            throw new FlowExecutionException(String.format("No transitions found in flow=%s for state=%s", this.getName(), stateName));
        }
        String next = null;
        String exitCode = status.getName();
        for (StateTransition stateTransition : set) {
            if (!stateTransition.matches(exitCode) && (!exitCode.equals("PENDING") || !stateTransition.matches("STOPPED"))) continue;
            if (stateTransition.isEnd()) {
                return null;
            }
            next = stateTransition.getNext();
            break;
        }
        if (next == null) {
            if (stepExecution != null) {
                exitCode = stepExecution.getStatus().toString();
                for (StateTransition stateTransition : set) {
                    if (!stateTransition.matches(exitCode) && (!exitCode.equals("PENDING") || !stateTransition.matches("STOPPED"))) continue;
                    if (stateTransition.isEnd()) {
                        return null;
                    }
                    next = stateTransition.getNext();
                    break;
                }
            }
            if (next == null) {
                throw new FlowExecutionException(String.format("Next state not found in flow=%s for state=%s with exit status=%s", this.getName(), stateName, status.getName()));
            }
        }
        if (!this.getStateMap().containsKey(next)) {
            throw new FlowExecutionException(String.format("Next state not specified in flow=%s for next=%s", this.getName(), next));
        }
        return this.getStateMap().get(next);
    }
}

