/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ConditionEvaluationReportMessage {
    private StringBuilder message;

    public ConditionEvaluationReportMessage(ConditionEvaluationReport report) {
        this.message = this.getLogMessage(report);
    }

    private StringBuilder getLogMessage(ConditionEvaluationReport report) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("%n%n%n", new Object[0]));
        message.append(String.format("=========================%n", new Object[0]));
        message.append(String.format("AUTO-CONFIGURATION REPORT%n", new Object[0]));
        message.append(String.format("=========================%n%n%n", new Object[0]));
        message.append(String.format("Positive matches:%n", new Object[0]));
        message.append(String.format("-----------------%n", new Object[0]));
        Map<String, ConditionEvaluationReport.ConditionAndOutcomes> shortOutcomes = this.orderByName(report.getConditionAndOutcomesBySource());
        for (Map.Entry<String, ConditionEvaluationReport.ConditionAndOutcomes> entry : shortOutcomes.entrySet()) {
            if (!entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Negative matches:%n", new Object[0]));
        message.append(String.format("-----------------%n", new Object[0]));
        for (Map.Entry<String, ConditionEvaluationReport.ConditionAndOutcomes> entry : shortOutcomes.entrySet()) {
            if (entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Exclusions:%n", new Object[0]));
        message.append(String.format("-----------%n", new Object[0]));
        if (report.getExclusions().isEmpty()) {
            message.append(String.format("%n    None%n", new Object[0]));
        } else {
            for (String exclusion : report.getExclusions()) {
                message.append(String.format("%n    %s%n", exclusion));
            }
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Unconditional classes:%n", new Object[0]));
        message.append(String.format("----------------------%n", new Object[0]));
        if (report.getUnconditionalClasses().isEmpty()) {
            message.append(String.format("%n    None%n", new Object[0]));
        } else {
            for (String unconditionalClass : report.getUnconditionalClasses()) {
                message.append(String.format("%n    %s%n", unconditionalClass));
            }
        }
        message.append(String.format("%n%n", new Object[0]));
        return message;
    }

    private Map<String, ConditionEvaluationReport.ConditionAndOutcomes> orderByName(Map<String, ConditionEvaluationReport.ConditionAndOutcomes> outcomes) {
        LinkedHashMap<String, ConditionEvaluationReport.ConditionAndOutcomes> result = new LinkedHashMap<String, ConditionEvaluationReport.ConditionAndOutcomes>();
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, String> classNames = new HashMap<String, String>();
        for (String name : outcomes.keySet()) {
            String shortName = ClassUtils.getShortName((String)name);
            names.add(shortName);
            classNames.put(shortName, name);
        }
        Collections.sort(names);
        for (String shortName : names) {
            result.put(shortName, outcomes.get(classNames.get(shortName)));
        }
        return result;
    }

    private void addLogMessage(StringBuilder message, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
        message.append(String.format("%n   %s", source));
        message.append(conditionAndOutcomes.isFullMatch() ? " matched" : " did not match").append(String.format("%n", new Object[0]));
        for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
            message.append("      - ");
            if (StringUtils.hasLength((String)conditionAndOutcome.getOutcome().getMessage())) {
                message.append(conditionAndOutcome.getOutcome().getMessage());
            } else {
                message.append(conditionAndOutcome.getOutcome().isMatch() ? "matched" : "did not match");
            }
            message.append(" (");
            message.append(ClassUtils.getShortName(conditionAndOutcome.getCondition().getClass()));
            message.append(String.format(")%n", new Object[0]));
        }
    }

    public String toString() {
        return this.message.toString();
    }
}

