/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.mock.runtime.InteractionScope;

public class MockController
implements IMockController {
    private final LinkedList<IInteractionScope> scopes = new LinkedList();
    private final List<InteractionNotSatisfiedError> errors = new ArrayList<InteractionNotSatisfiedError>();
    public static final String ADD_INTERACTION = "addInteraction";
    public static final String ADD_BARRIER = "addBarrier";
    public static final String ENTER_SCOPE = "enterScope";
    public static final String LEAVE_SCOPE = "leaveScope";

    public MockController() {
        this.scopes.addFirst(new InteractionScope());
    }

    public synchronized Object handle(IMockInvocation invocation) {
        for (IInteractionScope scope : this.scopes) {
            IMockInteraction interaction = scope.match(invocation);
            if (interaction == null) continue;
            try {
                return interaction.accept(invocation);
            }
            catch (InteractionNotSatisfiedError e) {
                this.errors.add(e);
                throw e;
            }
        }
        for (IInteractionScope scope : this.scopes) {
            scope.addUnmatchedInvocation(invocation);
        }
        return invocation.getMockObject().getDefaultResponse().respond(invocation);
    }

    public synchronized void addInteraction(IMockInteraction interaction) {
        this.scopes.getFirst().addInteraction(interaction);
    }

    public synchronized void addBarrier() {
        this.scopes.getFirst().addOrderingBarrier();
    }

    public synchronized void enterScope() {
        this.throwAnyPreviousError();
        this.scopes.addFirst(new InteractionScope());
    }

    public synchronized void leaveScope() {
        this.throwAnyPreviousError();
        IInteractionScope scope = this.scopes.removeFirst();
        scope.verifyInteractions();
    }

    private void throwAnyPreviousError() {
        if (!this.errors.isEmpty()) {
            throw this.errors.get(0);
        }
    }
}

