/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.spockframework.runtime.SpecUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=OptimizeRunOrderSuite.class)
public class OptimizeRunOrderSuite
extends Suite {
    public static final String CLASSES_TO_RUN_KEY = OptimizeRunOrderSuite.class.getName() + ".classesToRun";

    public OptimizeRunOrderSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(builder, clazz, (Class[])OptimizeRunOrderSuite.loadAndReorderClassesToRun());
    }

    private static Class<?>[] loadAndReorderClassesToRun() throws InitializationError {
        List<String> classNames = OptimizeRunOrderSuite.getClassesToRun();
        SpecUtil.optimizeRunOrder(classNames);
        List<Class<?>> classes = OptimizeRunOrderSuite.loadClasses(classNames);
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<String> getClassesToRun() throws InitializationError {
        String property = System.getProperty(CLASSES_TO_RUN_KEY);
        if (property == null) {
            throw new InitializationError(String.format("system property '%s' is not set", CLASSES_TO_RUN_KEY));
        }
        ArrayList<String> classNames = new ArrayList<String>();
        for (String name : property.split(",")) {
            classNames.add(name.trim());
        }
        return classNames;
    }

    private static List<Class<?>> loadClasses(List<String> classNames) throws InitializationError {
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = OptimizeRunOrderSuite.class.getClassLoader();
        try {
            for (String name : classNames) {
                classes.add(classLoader.loadClass(name));
            }
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
        return classes;
    }
}

