/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;
import org.spockframework.util.UnreachableCodeError;

public class JUnitFixtureMethodsExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo spec) {
        FixtureType.addInterceptors(spec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FixtureType {
        BEFORE(Before.class, false, MethodKind.SETUP, true),
        AFTER(After.class, false, MethodKind.CLEANUP, false),
        BEFORE_CLASS(BeforeClass.class, true, MethodKind.SETUP_SPEC, true),
        AFTER_CLASS(AfterClass.class, true, MethodKind.CLEANUP_SPEC, false);

        public final Class<? extends Annotation> annotationType;
        public final boolean isStatic;
        public final MethodKind interceptedMethodKind;
        public final boolean executeBeforeSpecMethod;

        private FixtureType(Class<? extends Annotation> annotationType, boolean isStatic, MethodKind interceptedMethodKind, boolean executeBeforeSpecMethod) {
            this.annotationType = annotationType;
            this.isStatic = isStatic;
            this.interceptedMethodKind = interceptedMethodKind;
            this.executeBeforeSpecMethod = executeBeforeSpecMethod;
        }

        private void addInterceptor(SpecInfo specInfo, Collection<Method> potentialMethods) {
            LinkedList<Method> fixtureMethods = new LinkedList<Method>();
            for (Method method : potentialMethods) {
                if (!this.isMethod(method)) continue;
                fixtureMethods.add(method);
            }
            if (!fixtureMethods.isEmpty()) {
                this.getInterceptedMethod(specInfo).addInterceptor(new FixtureMethodInterceptor(fixtureMethods));
            }
        }

        private MethodInfo getInterceptedMethod(SpecInfo specInfo) {
            for (MethodInfo methodInfo : specInfo.getFixtureMethods()) {
                if (!methodInfo.getKind().equals((Object)this.interceptedMethodKind)) continue;
                return methodInfo;
            }
            throw new UnreachableCodeError("failed to find fixture method of kind " + (Object)((Object)this.interceptedMethodKind));
        }

        private boolean isMethod(Method method) {
            boolean isMethod = method.getAnnotation(this.annotationType) != null && Modifier.isStatic(method.getModifiers()) == this.isStatic;
            return isMethod;
        }

        public static boolean isPotentialMethod(Method method) {
            boolean isPotential = method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0 && Modifier.isPublic(method.getModifiers());
            return isPotential;
        }

        public static void addInterceptors(SpecInfo spec) {
            for (SpecInfo currentSpec : spec.getSpecsBottomToTop()) {
                LinkedList<Method> potentialMethods = new LinkedList<Method>();
                for (Method method : ((Class)currentSpec.getReflection()).getDeclaredMethods()) {
                    if (!FixtureType.isPotentialMethod(method)) continue;
                    potentialMethods.add(method);
                }
                if (potentialMethods.isEmpty()) continue;
                for (FixtureType fixtureType : FixtureType.values()) {
                    fixtureType.addInterceptor(currentSpec, potentialMethods);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FixtureMethodInterceptor
        implements IMethodInterceptor {
            private final Collection<Method> methods;

            public FixtureMethodInterceptor(Collection<Method> methods) {
                this.methods = methods;
            }

            @Override
            public void intercept(IMethodInvocation invocation) throws Throwable {
                if (!FixtureType.this.executeBeforeSpecMethod) {
                    invocation.proceed();
                }
                for (Method method : this.methods) {
                    ReflectionUtil.invokeMethod(invocation.getTarget(), method, new Object[0]);
                }
                if (FixtureType.this.executeBeforeSpecMethod) {
                    invocation.proceed();
                }
            }
        }
    }
}

