/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.spockframework.lang.ConditionBlock;
import org.spockframework.runtime.SpockTimeoutError;
import org.spockframework.util.TimeUtil;

public class AsyncConditions {
    private final int numEvalBlocks;
    private final CountDownLatch latch;
    private final ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue();

    public AsyncConditions() {
        this(1);
    }

    public AsyncConditions(int numEvalBlocks) {
        this.numEvalBlocks = numEvalBlocks;
        this.latch = new CountDownLatch(numEvalBlocks);
    }

    @ConditionBlock
    public void evaluate(Runnable block) {
        try {
            block.run();
        }
        catch (Throwable t) {
            this.exceptions.add(t);
            this.wakeUp();
        }
        this.latch.countDown();
    }

    private void wakeUp() {
        long pendingEvalBlocks = this.latch.getCount();
        int i = 0;
        while ((long)i < pendingEvalBlocks) {
            this.latch.countDown();
            ++i;
        }
    }

    public void await() throws InterruptedException, Throwable {
        this.await(1.0);
    }

    public void await(double seconds) throws InterruptedException, Throwable {
        this.latch.await((long)(seconds * 1000.0), TimeUnit.MILLISECONDS);
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.poll();
        }
        long pendingEvalBlocks = this.latch.getCount();
        if (pendingEvalBlocks > 0L) {
            String msg = String.format("Async conditions timed out after %1.2f seconds; %d out of %d evaluate blocks did not complete in time", seconds, pendingEvalBlocks, this.numEvalBlocks);
            throw new SpockTimeoutError(seconds, msg);
        }
    }

    @Deprecated
    public void await(int value, TimeUnit unit) throws InterruptedException, Throwable {
        this.await(TimeUtil.toSeconds(value, unit));
    }
}

