/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PropertyParser {
    private static final String PROPERTY_ELEMENT = "property";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    private static final String JOB_PROPERTIES_BEAN_NAME = "jobProperties";
    private static final String BATCH_PROPERTY_CONTEXT_BEAN_NAME = "batchPropertyContext";
    private static final String JOB_PROPERTIES_PROPERTY_NAME = "jobProperties";
    private static final String STEP_PROPERTIES_PROPERTY_NAME = "stepProperties";
    private static final String ARTIFACT_PROPERTIES_PROPERTY_NAME = "artifactProperties";
    private static final String STEP_ARTIFACT_PROPERTIES_PROPERTY_NAME = "stepArtifactProperties";
    private String beanName;
    private String stepName;
    private ParserContext parserContext;
    private BatchArtifactType batchArtifactType;

    public PropertyParser(String beanName, ParserContext parserContext, BatchArtifactType batchArtifactType) {
        this.beanName = beanName;
        this.parserContext = parserContext;
        this.batchArtifactType = batchArtifactType;
    }

    public PropertyParser(String beanName, ParserContext parserContext, BatchArtifactType batchArtifactType, String stepName) {
        this(beanName, parserContext, batchArtifactType);
        this.stepName = stepName;
    }

    public void parseProperties(Element element) {
        List propertiesElements = DomUtils.getChildElementsByTagName((Element)element, (String)PROPERTIES_ELEMENT);
        if (propertiesElements.size() == 1) {
            this.parsePropertyElement((Element)propertiesElements.get(0));
        } else if (propertiesElements.size() > 1) {
            this.parserContext.getReaderContext().error("The <properties> element may not appear more than once.", (Object)element);
        }
    }

    public void parseProperty(Element element) {
        this.parsePropertyElement(element);
    }

    private void parsePropertyElement(Element propertyElement) {
        Properties properties = new Properties();
        for (Element element : DomUtils.getChildElementsByTagName((Element)propertyElement, (String)PROPERTY_ELEMENT)) {
            properties.put(element.getAttribute(PROPERTY_NAME_ATTRIBUTE), element.getAttribute(PROPERTY_VALUE_ATTRIBUTE));
        }
        this.setProperties(properties);
        this.setJobPropertiesBean(properties);
    }

    private void setProperties(Properties properties) {
        Map<Object, Object> propertyValue;
        BeanDefinition beanDefinition = this.parserContext.getRegistry().getBeanDefinition(BATCH_PROPERTY_CONTEXT_BEAN_NAME);
        if (this.batchArtifactType.equals((Object)BatchArtifactType.JOB)) {
            propertyValue = this.getJobProperties(properties);
        } else if (this.batchArtifactType.equals((Object)BatchArtifactType.STEP)) {
            propertyValue = this.getProperties(this.stepName, properties);
        } else if (this.batchArtifactType.equals((Object)BatchArtifactType.ARTIFACT)) {
            propertyValue = this.getProperties(this.beanName, properties);
        } else if (this.batchArtifactType.equals((Object)BatchArtifactType.STEP_ARTIFACT)) {
            propertyValue = this.getStepArtifactProperties(beanDefinition, properties);
        } else {
            throw new IllegalStateException("Unhandled BatchArtifactType of: " + (Object)((Object)this.batchArtifactType));
        }
        beanDefinition.getPropertyValues().addPropertyValue(this.getPropertyName(this.batchArtifactType), (Object)propertyValue);
    }

    private Map<String, Properties> getProperties(String keyName, Properties properties) {
        ManagedMap stepProperties = new ManagedMap();
        stepProperties.setMergeEnabled(true);
        stepProperties.put((Object)keyName, (Object)properties);
        return stepProperties;
    }

    private Properties getJobProperties(Properties properties) {
        return properties;
    }

    private Map<String, Map<String, Properties>> getStepArtifactProperties(BeanDefinition beanDefinition, Properties properties) {
        ManagedMap stepArtifacts = new ManagedMap();
        stepArtifacts.setMergeEnabled(true);
        Map existingArtifacts = (Map)beanDefinition.getPropertyValues().get(this.getPropertyName(this.batchArtifactType));
        ManagedMap artifactProperties = new ManagedMap();
        artifactProperties.setMergeEnabled(true);
        if (existingArtifacts != null && existingArtifacts.containsKey(this.stepName)) {
            Map existingArtifactsMap = (Map)existingArtifacts.get(this.stepName);
            for (Map.Entry existingArtifactEntry : existingArtifactsMap.entrySet()) {
                artifactProperties.put(existingArtifactEntry.getKey(), existingArtifactEntry.getValue());
            }
        }
        artifactProperties.put((Object)this.beanName, (Object)properties);
        stepArtifacts.put((Object)this.stepName, (Object)artifactProperties);
        return stepArtifacts;
    }

    private void setJobPropertiesBean(Properties properties) {
        if (this.batchArtifactType.equals((Object)BatchArtifactType.JOB)) {
            HashMap<String, String> jobProperties = new HashMap<String, String>();
            if (properties != null && !properties.isEmpty()) {
                for (String param : properties.stringPropertyNames()) {
                    jobProperties.put(param, properties.getProperty(param));
                }
            }
            BeanDefinition jobPropertiesBeanDefinition = this.parserContext.getRegistry().getBeanDefinition("jobProperties");
            jobPropertiesBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(jobProperties);
        }
    }

    private String getPropertyName(BatchArtifactType batchArtifactType) {
        if (batchArtifactType.equals((Object)BatchArtifactType.JOB)) {
            return "jobProperties";
        }
        if (batchArtifactType.equals((Object)BatchArtifactType.STEP)) {
            return STEP_PROPERTIES_PROPERTY_NAME;
        }
        if (batchArtifactType.equals((Object)BatchArtifactType.ARTIFACT)) {
            return ARTIFACT_PROPERTIES_PROPERTY_NAME;
        }
        if (batchArtifactType.equals((Object)BatchArtifactType.STEP_ARTIFACT)) {
            return STEP_ARTIFACT_PROPERTIES_PROPERTY_NAME;
        }
        throw new IllegalStateException("Unhandled BatchArtifactType of: " + (Object)((Object)batchArtifactType));
    }
}

