/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import javax.validation.ValidationException;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstrainedParameterBuilder;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ConstructorType;
import org.hibernate.validator.internal.xml.CrossParameterType;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.MethodType;
import org.hibernate.validator.internal.xml.ParameterType;
import org.hibernate.validator.internal.xml.ReturnValueType;

class ConstrainedExecutableBuilder {
    private static final Log log = LoggerFactory.make();

    private ConstrainedExecutableBuilder() {
    }

    static Set<ConstrainedExecutable> buildMethodConstrainedExecutable(List<MethodType> methods, Class<?> beanClass, String defaultPackage, ParameterNameProvider parameterNameProvider, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedMethods = CollectionHelper.newArrayList();
        for (MethodType methodType : methods) {
            List<Class<?>> parameterTypes = ConstrainedExecutableBuilder.createParameterTypes(methodType.getParameter(), beanClass, defaultPackage);
            String methodName = methodType.getName();
            Method method = ConstrainedExecutableBuilder.run(GetDeclaredMethod.action(beanClass, methodName, parameterTypes.toArray(new Class[parameterTypes.size()])));
            if (method == null) {
                throw log.getBeanDoesNotContainMethodException(beanClass.getName(), methodName, parameterTypes);
            }
            if (alreadyProcessedMethods.contains(method)) {
                throw log.getMethodIsDefinedTwiceInMappingXmlForBeanException(method.toString(), beanClass.getName());
            }
            alreadyProcessedMethods.add(method);
            ExecutableElement methodExecutableElement = ExecutableElement.forMethod(method);
            if (methodType.getIgnoreAnnotations() != null) {
                annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(method, methodType.getIgnoreAnnotations());
            }
            ConstrainedExecutable constrainedExecutable = ConstrainedExecutableBuilder.parseExecutableType(defaultPackage, methodType.getParameter(), methodType.getCrossParameter(), methodType.getReturnValue(), methodExecutableElement, constraintHelper, parameterNameProvider, annotationProcessingOptions);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    static Set<ConstrainedExecutable> buildConstructorConstrainedExecutable(List<ConstructorType> constructors, Class<?> beanClass, String defaultPackage, ParameterNameProvider parameterNameProvider, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList alreadyProcessedConstructors = CollectionHelper.newArrayList();
        for (ConstructorType constructorType : constructors) {
            List<Class<?>> constructorParameterTypes = ConstrainedExecutableBuilder.createParameterTypes(constructorType.getParameter(), beanClass, defaultPackage);
            Constructor constructor = (Constructor)ConstrainedExecutableBuilder.run(GetDeclaredConstructor.action(beanClass, constructorParameterTypes.toArray(new Class[constructorParameterTypes.size()])));
            if (constructor == null) {
                throw log.getBeanDoesNotContainConstructorException(beanClass.getName(), StringHelper.join(constructorParameterTypes, ", "));
            }
            if (alreadyProcessedConstructors.contains(constructor)) {
                throw log.getConstructorIsDefinedTwiceInMappingXmlForBeanException(constructor.toString(), beanClass.getName());
            }
            alreadyProcessedConstructors.add(constructor);
            ExecutableElement constructorExecutableElement = ExecutableElement.forConstructor(constructor);
            if (constructorType.getIgnoreAnnotations() != null) {
                annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(constructor, constructorType.getIgnoreAnnotations());
            }
            ConstrainedExecutable constrainedExecutable = ConstrainedExecutableBuilder.parseExecutableType(defaultPackage, constructorType.getParameter(), constructorType.getCrossParameter(), constructorType.getReturnValue(), constructorExecutableElement, constraintHelper, parameterNameProvider, annotationProcessingOptions);
            constrainedExecutables.add(constrainedExecutable);
        }
        return constrainedExecutables;
    }

    private static ConstrainedExecutable parseExecutableType(String defaultPackage, List<ParameterType> parameterTypeList, CrossParameterType crossParameterType, ReturnValueType returnValueType, ExecutableElement executableElement, ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        List<ConstrainedParameter> parameterMetaData = ConstrainedParameterBuilder.buildConstrainedParameters(parameterTypeList, executableElement, defaultPackage, constraintHelper, parameterNameProvider, annotationProcessingOptions);
        Set<MetaConstraint<?>> crossParameterConstraints = ConstrainedExecutableBuilder.parseCrossParameterConstraints(defaultPackage, crossParameterType, executableElement, constraintHelper, annotationProcessingOptions);
        HashSet<MetaConstraint<?>> returnValueConstraints = CollectionHelper.newHashSet();
        HashMap<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
        boolean isCascaded = ConstrainedExecutableBuilder.parseReturnValueType(returnValueType, executableElement, returnValueConstraints, groupConversions, defaultPackage, constraintHelper, annotationProcessingOptions);
        return new ConstrainedExecutable(ConfigurationSource.XML, ConstraintLocation.forReturnValue(executableElement), parameterMetaData, crossParameterConstraints, returnValueConstraints, Collections.<MetaConstraint<?>>emptySet(), groupConversions, isCascaded, UnwrapMode.AUTOMATIC);
    }

    private static Set<MetaConstraint<?>> parseCrossParameterConstraints(String defaultPackage, CrossParameterType crossParameterType, ExecutableElement executableElement, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        if (crossParameterType == null) {
            return crossParameterConstraints;
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forCrossParameter(executableElement);
        for (ConstraintType constraintType : crossParameterType.getConstraint()) {
            MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraintType, executableElement.getElementType(), defaultPackage, constraintHelper, ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER);
            crossParameterConstraints.add(metaConstraint);
        }
        if (crossParameterType.getIgnoreAnnotations() != null) {
            annotationProcessingOptions.ignoreConstraintAnnotationsForCrossParameterConstraint(executableElement.getMember(), crossParameterType.getIgnoreAnnotations());
        }
        return crossParameterConstraints;
    }

    private static boolean parseReturnValueType(ReturnValueType returnValueType, ExecutableElement executableElement, Set<MetaConstraint<?>> returnValueConstraints, Map<Class<?>, Class<?>> groupConversions, String defaultPackage, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        if (returnValueType == null) {
            return false;
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forReturnValue(executableElement);
        for (ConstraintType constraint : returnValueType.getConstraint()) {
            MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, executableElement.getElementType(), defaultPackage, constraintHelper, ConstraintDescriptorImpl.ConstraintType.GENERIC);
            returnValueConstraints.add(metaConstraint);
        }
        groupConversions.putAll(GroupConversionBuilder.buildGroupConversionMap(returnValueType.getConvertGroup(), defaultPackage));
        if (returnValueType.getIgnoreAnnotations() != null) {
            annotationProcessingOptions.ignoreConstraintAnnotationsForReturnValue(executableElement.getMember(), returnValueType.getIgnoreAnnotations());
        }
        return returnValueType.getValid() != null;
    }

    private static List<Class<?>> createParameterTypes(List<ParameterType> parameterList, Class<?> beanClass, String defaultPackage) {
        ArrayList<Class<?>> parameterTypes = CollectionHelper.newArrayList();
        for (ParameterType parameterType : parameterList) {
            String type = null;
            try {
                type = parameterType.getType();
                Class<?> parameterClass = ClassLoadingHelper.loadClass(type, defaultPackage);
                parameterTypes.add(parameterClass);
            }
            catch (ValidationException e) {
                throw log.getInvalidParameterTypeException(type, beanClass.getName());
            }
        }
        return parameterTypes;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

