/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.util.Arrays;
import java.util.List;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.runtime.DynamicMockMethod;
import org.spockframework.mock.runtime.GroovyRealMethodInvoker;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

public class GroovyMockMetaClass
extends DelegatingMetaClass {
    private final IMockConfiguration configuration;
    private final Specification specification;

    public GroovyMockMetaClass(IMockConfiguration configuration, Specification specification, MetaClass oldMetaClass) {
        super(oldMetaClass);
        this.configuration = configuration;
        this.specification = specification;
    }

    public Object invokeMethod(Object target, String method, Object[] arguments) {
        return this.doInvokeMethod(target, method, arguments, false);
    }

    public Object invokeStaticMethod(Object target, String method, Object[] arguments) {
        return this.doInvokeMethod(target, method, arguments, true);
    }

    public Object invokeConstructor(Object[] arguments) {
        return this.doInvokeMethod(this.configuration.getType(), "<init>", arguments, true);
    }

    public Object getProperty(Object target, String property) {
        String methodName = GroovyRuntimeUtil.propertyToMethodName("get", property);
        return this.invokeMethod(target, methodName, GroovyRuntimeUtil.EMPTY_ARGUMENTS);
    }

    public void setProperty(Object target, String property, Object newValue) {
        String methodName = GroovyRuntimeUtil.propertyToMethodName("set", property);
        this.invokeMethod(target, methodName, new Object[]{newValue});
    }

    private Object doInvokeMethod(Object target, String method, Object[] arguments, boolean isStatic) {
        if (this.isGetMetaClassCallOnGroovyObject(target, method, arguments = GroovyRuntimeUtil.asUnwrappedArgumentArray(arguments), isStatic)) {
            return ((GroovyObject)target).getMetaClass();
        }
        MetaMethod metaMethod = this.delegate.pickMethod(method, ReflectionUtil.getTypes(arguments));
        if (GroovyRuntimeUtil.isPhysicalMethod(metaMethod, this.configuration.getType()) && !isStatic && !this.configuration.isGlobal()) {
            return metaMethod.invoke(target, arguments);
        }
        if (metaMethod != null && metaMethod.getDeclaringClass().getTheClass() == GroovyObject.class) {
            if (method.equals("invokeMethod")) {
                return this.invokeMethod(target, (String)arguments[0], GroovyRuntimeUtil.asArgumentArray(arguments[1]));
            }
            if (method.equals("getProperty")) {
                return this.getProperty(target, (String)arguments[0]);
            }
            if (method.equals("setProperty")) {
                this.setProperty(target, (String)arguments[0], arguments[1]);
                return null;
            }
        }
        IMockInvocation invocation = this.createMockInvocation(metaMethod, target, method, arguments, isStatic);
        IMockController controller = this.specification.getSpecificationContext().getMockController();
        return controller.handle(invocation);
    }

    private boolean isGetMetaClassCallOnGroovyObject(Object target, String method, Object[] arguments, boolean isStatic) {
        return !isStatic && target instanceof GroovyObject && method.equals("getMetaClass") && arguments.length == 0;
    }

    private IMockInvocation createMockInvocation(MetaMethod metaMethod, Object target, String method, Object[] arguments, boolean isStatic) {
        DynamicMockMethod mockMethod;
        MockObject mockObject = new MockObject(this.configuration.getName(), this.configuration.getType(), target, this.configuration.isVerified(), this.configuration.isGlobal(), this.configuration.getDefaultResponse(), this.specification);
        if (metaMethod != null) {
            List<Class<?>> parameterTypes = Arrays.asList(metaMethod.getNativeParameterTypes());
            mockMethod = new DynamicMockMethod(method, parameterTypes, metaMethod.getReturnType(), isStatic);
        } else {
            mockMethod = new DynamicMockMethod(method, arguments.length, isStatic);
        }
        return new MockInvocation(mockObject, mockMethod, Arrays.asList(arguments), new GroovyRealMethodInvoker(this.getAdaptee()));
    }
}

