/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.util.UnreachableCodeError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRegistry {
    private final List<Class<?>> extensionClasses;
    private final List<Object> configurations;
    private final List<IGlobalExtension> extensions = new ArrayList<IGlobalExtension>();

    ExtensionRegistry(List<Class<?>> extensionClasses, List<Object> configurations) {
        this.extensionClasses = extensionClasses;
        this.configurations = configurations;
    }

    public void loadExtensions() {
        for (Class<?> clazz : this.extensionClasses) {
            this.extensions.add(this.configureExtension(this.instantiateExtension(this.verifyExtensionClass(clazz))));
        }
    }

    public List<IGlobalExtension> getExtensions() {
        return this.extensions;
    }

    private Class<?> verifyExtensionClass(Class<?> clazz) {
        if (!IGlobalExtension.class.isAssignableFrom(clazz)) {
            throw new ExtensionException("Class '%s' is not a valid global extension because it is not derived from '%s'").withArgs(clazz.getName(), IGlobalExtension.class.getName());
        }
        return clazz;
    }

    private IGlobalExtension instantiateExtension(Class<?> clazz) {
        try {
            return (IGlobalExtension)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate extension '%s'", e).withArgs(clazz.getName());
        }
    }

    private IGlobalExtension configureExtension(IGlobalExtension extension) {
        for (Field field : extension.getClass().getDeclaredFields()) {
            if (!field.getType().getSimpleName().endsWith("Configuration")) continue;
            this.injectConfiguration(field, extension);
        }
        return extension;
    }

    private void injectConfiguration(Field field, Object extension) {
        Object config = this.getOrCreateConfiguration(field.getType());
        field.setAccessible(true);
        try {
            field.set(extension, config);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableCodeError();
        }
    }

    private Object getOrCreateConfiguration(Class<?> type) {
        for (Object config : this.configurations) {
            if (config.getClass() != type) continue;
            return config;
        }
        Object config = this.createConfiguration(type);
        this.configurations.add(config);
        return config;
    }

    private Object createConfiguration(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException("Cannot instantiate configuration class %s").withArgs(type);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException("Configuration class '%s' has no public no-arg constructor").withArgs(type);
        }
    }
}

