/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Map;
import org.springframework.batch.core.job.flow.support.DefaultStateTransitionComparator;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CoreNamespaceUtils {
    private static final String STEP_SCOPE_PROCESSOR_BEAN_NAME = "org.springframework.batch.core.scope.internalStepScope";
    private static final String XML_CONFIG_STEP_SCOPE_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.scope.StepScope";
    private static final String JAVA_CONFIG_SCOPE_CLASS_NAME = "org.springframework.batch.core.configuration.annotation.ScopeConfiguration";
    private static final String JOB_SCOPE_PROCESSOR_BEAN_NAME = "org.springframework.batch.core.scope.internalJobScope";
    private static final String JOB_SCOPE_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.scope.JobScope";
    private static final String CUSTOM_EDITOR_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.config.CustomEditorConfigurer";
    private static final String RANGE_ARRAY_CLASS_NAME = "org.springframework.batch.item.file.transform.Range[]";
    private static final String RANGE_ARRAY_EDITOR_CLASS_NAME = "org.springframework.batch.item.file.transform.RangeArrayPropertyEditor";
    private static final String CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.configuration.xml.CoreNamespacePostProcessor";

    public static void autoregisterBeansForNamespace(ParserContext parserContext, Object source) {
        CoreNamespaceUtils.checkForStepScope(parserContext, source);
        CoreNamespaceUtils.checkForJobScope(parserContext, source);
        CoreNamespaceUtils.addRangePropertyEditor(parserContext);
        CoreNamespaceUtils.addCoreNamespacePostProcessor(parserContext);
        CoreNamespaceUtils.addStateTransitionComparator(parserContext);
    }

    private static void checkForStepScope(ParserContext parserContext, Object source) {
        CoreNamespaceUtils.checkForScope(parserContext, source, XML_CONFIG_STEP_SCOPE_PROCESSOR_CLASS_NAME, STEP_SCOPE_PROCESSOR_BEAN_NAME);
    }

    private static void checkForJobScope(ParserContext parserContext, Object source) {
        CoreNamespaceUtils.checkForScope(parserContext, source, JOB_SCOPE_PROCESSOR_CLASS_NAME, JOB_SCOPE_PROCESSOR_BEAN_NAME);
    }

    private static void checkForScope(ParserContext parserContext, Object source, String scopeClassName, String scopeBeanName) {
        String[] beanNames;
        boolean foundScope = false;
        for (String beanName : beanNames = parserContext.getRegistry().getBeanDefinitionNames()) {
            BeanDefinition bd = parserContext.getRegistry().getBeanDefinition(beanName);
            if (!scopeClassName.equals(bd.getBeanClassName()) && !JAVA_CONFIG_SCOPE_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            foundScope = true;
            break;
        }
        if (!foundScope) {
            BeanDefinitionBuilder stepScopeBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)scopeClassName);
            AbstractBeanDefinition abd = stepScopeBuilder.getBeanDefinition();
            abd.setRole(2);
            abd.setSource(source);
            parserContext.getRegistry().registerBeanDefinition(scopeBeanName, (BeanDefinition)abd);
        }
    }

    private static void addStateTransitionComparator(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.stateTransitionComparatorAlreadyDefined(registry)) {
            AbstractBeanDefinition defaultStateTransitionComparator = BeanDefinitionBuilder.genericBeanDefinition(DefaultStateTransitionComparator.class).getBeanDefinition();
            registry.registerBeanDefinition("batch_state_transition_comparator", (BeanDefinition)defaultStateTransitionComparator);
        }
    }

    private static boolean stateTransitionComparatorAlreadyDefined(BeanDefinitionRegistry registry) {
        return registry.containsBeanDefinition("batch_state_transition_comparator");
    }

    private static void addRangePropertyEditor(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.rangeArrayEditorAlreadyDefined(registry)) {
            AbstractBeanDefinition customEditorConfigurer = BeanDefinitionBuilder.genericBeanDefinition((String)CUSTOM_EDITOR_CONFIGURER_CLASS_NAME).getBeanDefinition();
            customEditorConfigurer.setRole(2);
            ManagedMap editors = new ManagedMap();
            editors.put((Object)RANGE_ARRAY_CLASS_NAME, (Object)RANGE_ARRAY_EDITOR_CLASS_NAME);
            customEditorConfigurer.getPropertyValues().addPropertyValue("customEditors", (Object)editors);
            registry.registerBeanDefinition(CUSTOM_EDITOR_CONFIGURER_CLASS_NAME, (BeanDefinition)customEditorConfigurer);
        }
    }

    private static boolean rangeArrayEditorAlreadyDefined(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            PropertyValue pv;
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!CUSTOM_EDITOR_CONFIGURER_CLASS_NAME.equals(bd.getBeanClassName()) || (pv = bd.getPropertyValues().getPropertyValue("customEditors")) == null) continue;
            for (Map.Entry entry : ((Map)pv.getValue()).entrySet()) {
                if (!(entry.getKey() instanceof TypedStringValue ? RANGE_ARRAY_CLASS_NAME.equals(((TypedStringValue)entry.getKey()).getValue()) : entry.getKey() instanceof String && RANGE_ARRAY_CLASS_NAME.equals(entry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    private static void addCoreNamespacePostProcessor(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.coreNamespaceBeanPostProcessorAlreadyDefined(registry)) {
            AbstractBeanDefinition postProcessorBeanDef = BeanDefinitionBuilder.genericBeanDefinition((String)CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME).getBeanDefinition();
            postProcessorBeanDef.setRole(2);
            registry.registerBeanDefinition(CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME, (BeanDefinition)postProcessorBeanDef);
        }
    }

    private static boolean coreNamespaceBeanPostProcessorAlreadyDefined(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderspecified(Element element) {
        return CoreNamespaceUtils.isAbstract(element) || StringUtils.hasText((String)element.getAttribute("parent"));
    }

    public static boolean isAbstract(Element element) {
        String abstractAttr = element.getAttribute("abstract");
        return StringUtils.hasText((String)abstractAttr) && Boolean.valueOf(abstractAttr) != false;
    }

    public static boolean namespaceMatchesVersion(Element element) {
        return CoreNamespaceUtils.matchesVersionInternal(element) && CoreNamespaceUtils.matchesVersionInternal(element.getOwnerDocument().getDocumentElement());
    }

    private static boolean matchesVersionInternal(Element element) {
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        return schemaLocation.matches("(?m).*spring-batch-3.0.xsd.*") || schemaLocation.matches("(?m).*spring-batch-2.2.xsd.*") || schemaLocation.matches("(?m).*spring-batch.xsd.*") || !schemaLocation.matches("(?m).*spring-batch.*");
    }
}

