/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Properties;
import org.springframework.batch.core.jsr.configuration.xml.JsrBeanDefinitionDocumentReader;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

public class JsrXmlApplicationContext
extends GenericApplicationContext {
    private static final String JOB_PARAMETERS_BEAN_DEFINITION_NAME = "jsr_jobParameters";
    private XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this);

    public JsrXmlApplicationContext() {
        this.reader.setDocumentReaderClass(JsrBeanDefinitionDocumentReader.class);
        this.reader.setEnvironment((Environment)this.getEnvironment());
    }

    public JsrXmlApplicationContext(Properties jobParameters) {
        this.reader.setDocumentReaderClass(JsrBeanDefinitionDocumentReader.class);
        this.reader.setEnvironment((Environment)this.getEnvironment());
        this.storeJobParameters(jobParameters);
    }

    private void storeJobParameters(Properties properties) {
        AbstractBeanDefinition jobParameters = BeanDefinitionBuilder.genericBeanDefinition(Properties.class).getBeanDefinition();
        jobParameters.getConstructorArgumentValues().addGenericArgumentValue((Object)(properties != null ? properties : new Properties()));
        this.reader.getRegistry().registerBeanDefinition(JOB_PARAMETERS_BEAN_DEFINITION_NAME, (BeanDefinition)jobParameters);
    }

    protected XmlBeanDefinitionReader getReader() {
        return this.reader;
    }

    public void setValidating(boolean validating) {
        this.reader.setValidating(validating);
    }

    public void load(Resource ... resources) {
        this.reader.loadBeanDefinitions(resources);
    }
}

