/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job.flow;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.xml.SimpleFlowFactoryBean;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.job.flow.JobFlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.state.FlowState;
import org.springframework.batch.core.jsr.job.JsrStepHandler;
import org.springframework.batch.core.jsr.job.flow.JsrFlowExecutor;
import org.springframework.batch.core.jsr.job.flow.support.JsrFlow;
import org.springframework.batch.core.jsr.job.flow.support.state.JsrStepState;
import org.springframework.batch.core.jsr.step.DecisionStep;
import org.springframework.batch.core.launch.NoSuchJobException;

public class JsrFlowJob
extends FlowJob {
    private JobExplorer jobExplorer;

    public JsrFlowJob() {
    }

    public JsrFlowJob(String name) {
        super(name);
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    @Override
    protected void doExecute(JobExecution execution) throws JobExecutionException {
        try {
            JsrFlowExecutor executor = new JsrFlowExecutor(this.getJobRepository(), new JsrStepHandler(this.getJobRepository(), this.jobExplorer), execution);
            State startState = ((JsrFlow)this.flow).getStartState();
            this.validateFirstStep(startState);
            ((JobFlowExecutor)executor).updateJobExecutionStatus(this.flow.start(executor).getStatus());
        }
        catch (FlowExecutionException e) {
            if (e.getCause() instanceof JobExecutionException) {
                throw (JobExecutionException)e.getCause();
            }
            throw new JobExecutionException("Flow execution ended unexpectedly", e);
        }
    }

    private void validateFirstStep(State startState) throws JobExecutionException {
        while (true) {
            if (startState instanceof SimpleFlowFactoryBean.DelegateState) {
                startState = ((SimpleFlowFactoryBean.DelegateState)startState).getState();
                continue;
            }
            if (startState instanceof JsrStepState) {
                String stepName = startState.getName().substring(startState.getName().indexOf(".") + 1, startState.getName().length());
                Step step = ((JsrStepState)startState).getStep(stepName);
                if (!(step instanceof DecisionStep)) break;
                throw new JobExecutionException("Decision step is an invalid first step");
            }
            if (!(startState instanceof FlowState)) break;
            Flow firstFlow = ((FlowState)startState).getFlows().iterator().next();
            startState = firstFlow.getStates().iterator().next();
        }
    }

    @Override
    protected ExitStatus getDefaultExitStatusForFailure(Throwable ex, JobExecution execution) {
        if (!ExitStatus.isNonDefaultExitStatus(execution.getExitStatus())) {
            return execution.getExitStatus();
        }
        ExitStatus exitStatus = ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException ? ExitStatus.STOPPED.addExitDescription(JobInterruptedException.class.getName()) : (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException ? new ExitStatus("NO_SUCH_JOB", ex.getClass().getName()) : ExitStatus.FAILED.addExitDescription(ex));
        return exitStatus;
    }
}

